/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped;

import com.morelaid.streamingmodule.external.j256.ormlite.dao.Dao;
import com.morelaid.streamingmodule.external.j256.ormlite.dao.ObjectCache;
import com.morelaid.streamingmodule.external.j256.ormlite.db.DatabaseType;
import com.morelaid.streamingmodule.external.j256.ormlite.field.FieldType;
import com.morelaid.streamingmodule.external.j256.ormlite.stmt.mapped.BaseMappedStatement;
import com.morelaid.streamingmodule.external.j256.ormlite.support.DatabaseConnection;
import com.morelaid.streamingmodule.external.j256.ormlite.table.TableInfo;
import java.sql.SQLException;

public class MappedUpdateId<T, ID>
extends BaseMappedStatement<T, ID> {
    private MappedUpdateId(Dao<T, ID> dao, TableInfo<T, ID> tableInfo, String statement, FieldType[] argFieldTypes) {
        super(dao, tableInfo, statement, argFieldTypes);
    }

    public int execute(DatabaseConnection databaseConnection, T data, ID newId, ObjectCache objectCache) throws SQLException {
        try {
            Object[] args2 = new Object[]{this.convertIdToFieldObject(newId), this.extractIdToFieldObject(data)};
            int rowC = databaseConnection.update(this.statement, args2, this.argFieldTypes);
            if (rowC > 0) {
                Object oldId;
                Object obj;
                if (objectCache != null && (obj = objectCache.updateId(this.clazz, oldId = this.idField.extractJavaFieldValue(data), newId)) != null && obj != data) {
                    this.idField.assignField(this.connectionSource, obj, newId, false, objectCache);
                }
                this.idField.assignField(this.connectionSource, data, newId, false, objectCache);
            }
            logger.debug("updating-id with statement '{}' and {} args, changed {} rows", (Object)this.statement, (Object)args2.length, (Object)rowC);
            if (args2.length > 0) {
                logger.trace("updating-id arguments: {}", (Object)args2);
            }
            return rowC;
        }
        catch (SQLException e) {
            throw new SQLException("Unable to run update-id stmt on object " + data + ": " + this.statement, e);
        }
    }

    public static <T, ID> MappedUpdateId<T, ID> build(Dao<T, ID> dao, TableInfo<T, ID> tableInfo) throws SQLException {
        FieldType idField = tableInfo.getIdField();
        if (idField == null) {
            throw new SQLException("Cannot update-id in " + tableInfo.getDataClass() + " because it doesn't have an id field");
        }
        StringBuilder sb = new StringBuilder(64);
        DatabaseType databaseType = dao.getConnectionSource().getDatabaseType();
        MappedUpdateId.appendTableName(databaseType, sb, "UPDATE ", tableInfo);
        sb.append("SET ");
        MappedUpdateId.appendFieldColumnName(databaseType, sb, idField, null);
        sb.append("= ? ");
        MappedUpdateId.appendWhereFieldEq(databaseType, idField, sb, null);
        return new MappedUpdateId<T, ID>(dao, tableInfo, sb.toString(), new FieldType[]{idField, idField});
    }

    private Object extractIdToFieldObject(T data) throws SQLException {
        return this.idField.extractJavaFieldToSqlArgValue(data);
    }
}

