/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.jackson.databind.deser.std;

import com.morelaid.streamingmodule.external.jackson.core.JsonLocation;
import com.morelaid.streamingmodule.external.jackson.core.io.ContentReference;
import com.morelaid.streamingmodule.external.jackson.databind.DeserializationConfig;
import com.morelaid.streamingmodule.external.jackson.databind.DeserializationContext;
import com.morelaid.streamingmodule.external.jackson.databind.JavaType;
import com.morelaid.streamingmodule.external.jackson.databind.PropertyMetadata;
import com.morelaid.streamingmodule.external.jackson.databind.PropertyName;
import com.morelaid.streamingmodule.external.jackson.databind.deser.CreatorProperty;
import com.morelaid.streamingmodule.external.jackson.databind.deser.SettableBeanProperty;
import com.morelaid.streamingmodule.external.jackson.databind.deser.ValueInstantiator;

public class JsonLocationInstantiator
extends ValueInstantiator.Base {
    private static final long serialVersionUID = 1L;

    public JsonLocationInstantiator() {
        super(JsonLocation.class);
    }

    @Override
    public boolean canCreateFromObjectWith() {
        return true;
    }

    @Override
    public SettableBeanProperty[] getFromObjectArguments(DeserializationConfig config) {
        JavaType intType = config.constructType(Integer.TYPE);
        JavaType longType = config.constructType(Long.TYPE);
        return new SettableBeanProperty[]{JsonLocationInstantiator.creatorProp("sourceRef", config.constructType(Object.class), 0), JsonLocationInstantiator.creatorProp("byteOffset", longType, 1), JsonLocationInstantiator.creatorProp("charOffset", longType, 2), JsonLocationInstantiator.creatorProp("lineNr", intType, 3), JsonLocationInstantiator.creatorProp("columnNr", intType, 4)};
    }

    private static CreatorProperty creatorProp(String name, JavaType type, int index) {
        return CreatorProperty.construct(PropertyName.construct(name), type, null, null, null, null, index, null, PropertyMetadata.STD_REQUIRED);
    }

    @Override
    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args2) {
        ContentReference srcRef = ContentReference.rawReference(args2[0]);
        return new JsonLocation(srcRef, JsonLocationInstantiator._long(args2[1]), JsonLocationInstantiator._long(args2[2]), JsonLocationInstantiator._int(args2[3]), JsonLocationInstantiator._int(args2[4]));
    }

    private static final long _long(Object o) {
        return o == null ? 0L : ((Number)o).longValue();
    }

    private static final int _int(Object o) {
        return o == null ? 0 : ((Number)o).intValue();
    }
}

