/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.jackson.datatype.jsr310.deser;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonFormat;
import com.morelaid.streamingmodule.external.jackson.core.JsonParser;
import com.morelaid.streamingmodule.external.jackson.core.JsonToken;
import com.morelaid.streamingmodule.external.jackson.core.StreamReadCapability;
import com.morelaid.streamingmodule.external.jackson.core.io.NumberInput;
import com.morelaid.streamingmodule.external.jackson.databind.DeserializationContext;
import com.morelaid.streamingmodule.external.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;
import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;

public class YearDeserializer
extends JSR310DateTimeDeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    public YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter formatter) {
        super(Year.class, formatter);
    }

    protected YearDeserializer(YearDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    public YearDeserializer(YearDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    protected YearDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    protected YearDeserializer withLeniency(Boolean leniency) {
        return new YearDeserializer(this, leniency);
    }

    @Override
    public Year deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonToken t2 = p.currentToken();
        if (t2 == JsonToken.VALUE_STRING) {
            return this._fromString(p, ctxt, p.getText());
        }
        if (t2 == JsonToken.START_OBJECT) {
            String str = ctxt.extractScalarFromObject(p, this, this.handledType());
            if (str != null) {
                return this._fromString(p, ctxt, str);
            }
        } else {
            if (t2 == JsonToken.VALUE_NUMBER_INT) {
                return this._fromNumber(ctxt, p.getIntValue());
            }
            if (t2 == JsonToken.VALUE_EMBEDDED_OBJECT) {
                return (Year)p.getEmbeddedObject();
            }
            if (p.isExpectedStartArrayToken()) {
                return (Year)this._deserializeFromArray(p, ctxt);
            }
        }
        return (Year)this._handleUnexpectedToken(ctxt, p, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }

    protected Year _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (Year)this._fromEmptyString(p, ctxt, string);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string)) {
            return this._fromNumber(ctxt, NumberInput.parseInt(string));
        }
        try {
            if (this._formatter == null) {
                return Year.parse(string);
            }
            return Year.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (Year)this._handleDateTimeException(ctxt, e, string);
        }
    }

    protected Year _fromNumber(DeserializationContext ctxt, int value) {
        return Year.of(value);
    }
}

