/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j;

import com.morelaid.streamingmodule.external.twitch4j.TwitchClientHelper;
import com.morelaid.streamingmodule.external.twitch4j.common.util.CollectionUtils;
import com.morelaid.streamingmodule.external.twitch4j.domain.ChannelCache;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelix;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.User;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.UserList;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public interface IClientHelper
extends AutoCloseable {
    public TwitchHelix getTwitchHelix();

    public boolean enableStreamEventListener(String var1, String var2);

    public boolean disableStreamEventListenerForId(String var1);

    public boolean enableFollowEventListener(String var1, String var2);

    public boolean disableFollowEventListenerForId(String var1);

    public boolean enableClipEventListener(String var1, String var2, Instant var3);

    public boolean disableClipEventListenerForId(String var1);

    public Optional<ChannelCache> getCachedInformation(String var1);

    public void setThreadDelay(long var1);

    @Nullable
    default public User enableStreamEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            User user = users.getUsers().get(0);
            if (this.enableStreamEventListener(user.getId(), user.getLogin())) {
                return user;
            }
        } else {
            TwitchClientHelper.log.error("Failed to add channel {} to stream event listener!", (Object)channelName);
        }
        return null;
    }

    default public Collection<User> enableStreamEventListener(Iterable<String> channelNames) {
        return CollectionUtils.chunked(channelNames, 100).stream().map(channels -> this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute()).map(UserList::getUsers).filter(Objects::nonNull).flatMap(Collection::stream).filter(user -> this.enableStreamEventListener(user.getId(), user.getLogin())).collect(Collectors.toList());
    }

    default public void disableStreamEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            users.getUsers().forEach(user -> this.disableStreamEventListenerForId(user.getId()));
        } else {
            TwitchClientHelper.log.error("Failed to remove channel " + channelName + " from stream event listener!");
        }
    }

    default public void disableStreamEventListener(Iterable<String> channelNames) {
        CollectionUtils.chunked(channelNames, 100).forEach(channels -> {
            UserList users = this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute();
            users.getUsers().forEach(user -> this.disableStreamEventListenerForId(user.getId()));
        });
    }

    @Nullable
    default public User enableFollowEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            User user = users.getUsers().get(0);
            if (this.enableFollowEventListener(user.getId(), user.getLogin())) {
                return user;
            }
        } else {
            TwitchClientHelper.log.error("Failed to add channel " + channelName + " to Follow Listener, maybe it doesn't exist!");
        }
        return null;
    }

    default public Collection<User> enableFollowEventListener(Iterable<String> channelNames) {
        return CollectionUtils.chunked(channelNames, 100).stream().map(channels -> this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute()).map(UserList::getUsers).filter(Objects::nonNull).flatMap(Collection::stream).filter(user -> this.enableFollowEventListener(user.getId(), user.getLogin())).collect(Collectors.toList());
    }

    default public void disableFollowEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            users.getUsers().forEach(user -> this.disableFollowEventListenerForId(user.getId()));
        } else {
            TwitchClientHelper.log.error("Failed to remove channel " + channelName + " from follow listener!");
        }
    }

    default public void disableFollowEventListener(Iterable<String> channelNames) {
        CollectionUtils.chunked(channelNames, 100).forEach(channels -> {
            UserList users = this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute();
            users.getUsers().forEach(user -> this.disableFollowEventListenerForId(user.getId()));
        });
    }

    default public boolean enableClipEventListener(String channelId, String channelName) {
        return this.enableClipEventListener(channelId, channelName, Instant.now());
    }

    @Nullable
    default public User enableClipEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            User user = users.getUsers().get(0);
            if (this.enableClipEventListener(user.getId(), user.getLogin())) {
                return user;
            }
        } else {
            TwitchClientHelper.log.error("Failed to add channel " + channelName + " to Clip Creation Listener, maybe it doesn't exist!");
        }
        return null;
    }

    default public Collection<User> enableClipEventListener(Iterable<String> channelNames) {
        return CollectionUtils.chunked(channelNames, 100).stream().map(channels -> this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute()).map(UserList::getUsers).filter(Objects::nonNull).flatMap(Collection::stream).filter(user -> this.enableClipEventListener(user.getId(), user.getLogin())).collect(Collectors.toList());
    }

    default public boolean disableClipEventListener(String channelName) {
        UserList users = this.getTwitchHelix().getUsers(null, null, Collections.singletonList(channelName)).execute();
        if (users.getUsers().size() == 1) {
            return this.disableClipEventListenerForId(users.getUsers().get(0).getId());
        }
        TwitchClientHelper.log.error("Failed to remove channel " + channelName + " from clip creation listener!");
        return false;
    }

    default public void disableClipEventListener(Iterable<String> channelNames) {
        CollectionUtils.chunked(channelNames, 100).forEach(channels -> {
            UserList users = this.getTwitchHelix().getUsers(null, null, (List<String>)channels).execute();
            users.getUsers().forEach(user -> this.disableClipEventListenerForId(user.getId()));
        });
    }

    default public void setThreadRate(long threadRate) {
        this.setThreadDelay(1000L / threadRate);
    }
}

