/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.auth;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.morelaid.streamingmodule.external.twitch4j.auth.providers.TwitchIdentityProvider;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchAuth {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchAuth.class);
    private final CredentialManager credentialManager;

    public TwitchAuth(CredentialManager credentialManager, String clientId, String clientSecret, String redirectUrl) {
        this.credentialManager = credentialManager;
        TwitchAuth.registerIdentityProvider(credentialManager, clientId, clientSecret, redirectUrl, false);
    }

    public static void registerIdentityProvider(CredentialManager credentialManager, String clientId, String clientSecret, String redirectUrl, boolean useMock) {
        Optional<TwitchIdentityProvider> ip = credentialManager.getIdentityProviderByName("twitch", TwitchIdentityProvider.class);
        if (!ip.isPresent()) {
            String baseUrl = useMock ? "http://localhost:8080/auth" : "https://id.twitch.tv/oauth2";
            TwitchIdentityProvider identityProvider = new TwitchIdentityProvider(clientId, clientSecret, redirectUrl, baseUrl);
            try {
                credentialManager.registerIdentityProvider(identityProvider);
            }
            catch (Exception e) {
                log.error("TwitchAuth: Encountered conflicting identity provider!", e);
            }
        } else {
            log.debug("TwitchIdentityProvider was already registered, ignoring call to TwitchAuth.registerIdentityProvider!");
        }
    }

    @Generated
    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }
}

