/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat;

import com.github.philippheuer.credentialmanager.CredentialManager;
import com.github.philippheuer.credentialmanager.CredentialManagerBuilder;
import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.github.philippheuer.events4j.api.service.IEventHandler;
import com.github.philippheuer.events4j.core.EventManager;
import com.github.philippheuer.events4j.simple.SimpleEventHandler;
import com.morelaid.streamingmodule.external.twitch4j.auth.TwitchAuth;
import com.morelaid.streamingmodule.external.twitch4j.auth.providers.TwitchIdentityProvider;
import com.morelaid.streamingmodule.external.twitch4j.chat.TwitchChat;
import com.morelaid.streamingmodule.external.twitch4j.chat.enums.MirroredMessagePolicy;
import com.morelaid.streamingmodule.external.twitch4j.chat.util.TwitchChatLimitHelper;
import com.morelaid.streamingmodule.external.twitch4j.client.websocket.WebsocketConnection;
import com.morelaid.streamingmodule.external.twitch4j.common.config.ProxyConfig;
import com.morelaid.streamingmodule.external.twitch4j.common.config.Twitch4JGlobal;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.TwitchLimitType;
import com.morelaid.streamingmodule.external.twitch4j.common.util.BucketUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.CryptoUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.EventManagerUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.ThreadUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TwitchLimitRegistry;
import com.morelaid.streamingmodule.external.twitch4j.util.IBackoffStrategy;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchChatBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchChatBuilder.class);
    private WebsocketConnection websocketConnection = null;
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private Integer requestQueueSize = -1;
    private EventManager eventManager;
    private Class<? extends IEventHandler> defaultEventHandler = SimpleEventHandler.class;
    private CredentialManager credentialManager = CredentialManagerBuilder.builder().build();
    private OAuth2Credential chatAccount;
    private String baseUrl = "wss://irc-ws.chat.twitch.tv:443";
    private boolean sendCredentialToThirdPartyHost = false;
    protected Collection<String> botOwnerIds = new HashSet<String>();
    protected Set<String> commandPrefixes = new HashSet<String>();
    protected Integer chatQueueSize = 200;
    protected Bandwidth chatRateLimit = TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    @Deprecated
    protected Bandwidth[] whisperRateLimit = TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    protected Bandwidth joinRateLimit = TwitchChatLimitHelper.USER_JOIN_LIMIT;
    protected Bandwidth authRateLimit = TwitchChatLimitHelper.USER_AUTH_LIMIT;
    protected Bandwidth perChannelRateLimit = BucketUtils.simple(100L, Duration.ofSeconds(30L), "per-channel-limit");
    protected Bucket ircMessageBucket = null;
    @Deprecated
    protected Bucket ircWhisperBucket = null;
    protected Bucket ircJoinBucket = null;
    protected Bucket ircAuthBucket = null;
    private ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = null;
    private long chatQueueTimeout = 1000L;
    private ProxyConfig proxyConfig = null;
    private boolean autoJoinOwnChannel = true;
    private boolean enableMembershipEvents = true;
    private boolean removeChannelOnJoinFailure = false;
    private int maxJoinRetries = 7;
    private long chatJoinTimeout = 2000L;
    private int wsPingPeriod = 15000;
    private int wsCloseDelay = 1000;
    private IBackoffStrategy connectionBackoffStrategy = null;
    private boolean verifyChatAccountOnReconnect = true;
    private BiPredicate<TwitchChat, String> outboundCommandFilter = null;
    private MirroredMessagePolicy mirroredMessagePolicy = MirroredMessagePolicy.REJECT_IF_OBSERVED;
    private Predicate<String> joinedToRoomId;
    private Cache<String, Boolean> observedMessageIds;

    public static TwitchChatBuilder builder() {
        return new TwitchChatBuilder();
    }

    public TwitchChat build() {
        String userId;
        log.debug("TwitchChat: Initializing ErrorTracking ...");
        if (this.scheduledThreadPoolExecutor == null) {
            this.scheduledThreadPoolExecutor = ThreadUtils.getDefaultScheduledThreadPoolExecutor("twitch4j-chat-" + CryptoUtils.generateNonce(4), 2);
        }
        if (this.mirroredMessagePolicy == MirroredMessagePolicy.REJECT_IF_OBSERVED && this.observedMessageIds == null) {
            this.observedMessageIds = CacheApi.create(spec -> {
                spec.expiryTime(Duration.ofSeconds(10L));
                spec.expiryType(ExpiryType.POST_WRITE);
                spec.maxSize(1024L);
            });
        }
        this.eventManager = EventManagerUtils.validateOrInitializeEventManager(this.eventManager, this.defaultEventHandler);
        if (this.credentialManager == null) {
            this.credentialManager = CredentialManagerBuilder.builder().build();
        }
        TwitchAuth.registerIdentityProvider(this.credentialManager, this.clientId, this.clientSecret, null, false);
        if (this.chatAccount == null) {
            userId = null;
        } else {
            if (StringUtils.isEmpty(this.chatAccount.getUserId())) {
                this.credentialManager.getIdentityProviderByName("twitch", TwitchIdentityProvider.class).flatMap(tip -> tip.getAdditionalCredentialInformation(this.chatAccount)).ifPresent(this.chatAccount::updateCredential);
            }
            userId = StringUtils.defaultIfEmpty(this.chatAccount.getUserId(), null);
        }
        if (this.ircMessageBucket == null) {
            Bucket bucket = this.ircMessageBucket = userId == null ? BucketUtils.createBucket(this.chatRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_MESSAGE_LIMIT, Collections.singletonList(this.chatRateLimit));
        }
        if (this.ircWhisperBucket == null) {
            Bucket bucket = this.ircWhisperBucket = userId == null ? BucketUtils.createBucket(this.whisperRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_WHISPER_LIMIT, Arrays.asList(this.whisperRateLimit));
        }
        if (this.ircJoinBucket == null) {
            Bucket bucket = this.ircJoinBucket = userId == null ? BucketUtils.createBucket(this.joinRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_JOIN_LIMIT, Collections.singletonList(this.joinRateLimit));
        }
        if (this.ircAuthBucket == null) {
            Bucket bucket = this.ircAuthBucket = userId == null ? BucketUtils.createBucket(this.authRateLimit) : TwitchLimitRegistry.getInstance().getOrInitializeBucket(userId, TwitchLimitType.CHAT_AUTH_LIMIT, Collections.singletonList(this.authRateLimit));
        }
        if (this.perChannelRateLimit == null) {
            this.perChannelRateLimit = this.chatRateLimit;
        }
        log.debug("TwitchChat: Initializing Module ...");
        return new TwitchChat(this.websocketConnection, this.eventManager, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.commandPrefixes, this.chatQueueSize, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.botOwnerIds, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.connectionBackoffStrategy, this.perChannelRateLimit, this.verifyChatAccountOnReconnect, this.wsCloseDelay, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    public TwitchChatBuilder withCommandTrigger(String commandTrigger) {
        this.commandPrefixes.add(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withCommandTriggers(Collection<String> commandTrigger) {
        this.commandPrefixes.addAll(commandTrigger);
        return this;
    }

    public TwitchChatBuilder withBotOwnerId(String userId) {
        this.botOwnerIds.add(userId);
        return this;
    }

    public TwitchChatBuilder withBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds.addAll(botOwnerIds);
        return this;
    }

    @Generated
    public WebsocketConnection getWebsocketConnection() {
        return this.websocketConnection;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    @Generated
    public EventManager getEventManager() {
        return this.eventManager;
    }

    @Generated
    public Class<? extends IEventHandler> getDefaultEventHandler() {
        return this.defaultEventHandler;
    }

    @Generated
    public CredentialManager getCredentialManager() {
        return this.credentialManager;
    }

    @Generated
    public OAuth2Credential getChatAccount() {
        return this.chatAccount;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public boolean isSendCredentialToThirdPartyHost() {
        return this.sendCredentialToThirdPartyHost;
    }

    @Generated
    public Collection<String> getBotOwnerIds() {
        return this.botOwnerIds;
    }

    @Generated
    public Set<String> getCommandPrefixes() {
        return this.commandPrefixes;
    }

    @Generated
    public Integer getChatQueueSize() {
        return this.chatQueueSize;
    }

    @Generated
    public Bandwidth getChatRateLimit() {
        return this.chatRateLimit;
    }

    @Deprecated
    @Generated
    public Bandwidth[] getWhisperRateLimit() {
        return this.whisperRateLimit;
    }

    @Generated
    public Bandwidth getJoinRateLimit() {
        return this.joinRateLimit;
    }

    @Generated
    public Bandwidth getAuthRateLimit() {
        return this.authRateLimit;
    }

    @Generated
    public Bandwidth getPerChannelRateLimit() {
        return this.perChannelRateLimit;
    }

    @Generated
    public Bucket getIrcMessageBucket() {
        return this.ircMessageBucket;
    }

    @Deprecated
    @Generated
    public Bucket getIrcWhisperBucket() {
        return this.ircWhisperBucket;
    }

    @Generated
    public Bucket getIrcJoinBucket() {
        return this.ircJoinBucket;
    }

    @Generated
    public Bucket getIrcAuthBucket() {
        return this.ircAuthBucket;
    }

    @Generated
    public ScheduledThreadPoolExecutor getScheduledThreadPoolExecutor() {
        return this.scheduledThreadPoolExecutor;
    }

    @Generated
    public long getChatQueueTimeout() {
        return this.chatQueueTimeout;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public boolean isAutoJoinOwnChannel() {
        return this.autoJoinOwnChannel;
    }

    @Generated
    public boolean isEnableMembershipEvents() {
        return this.enableMembershipEvents;
    }

    @Generated
    public boolean isRemoveChannelOnJoinFailure() {
        return this.removeChannelOnJoinFailure;
    }

    @Generated
    public int getMaxJoinRetries() {
        return this.maxJoinRetries;
    }

    @Generated
    public long getChatJoinTimeout() {
        return this.chatJoinTimeout;
    }

    @Generated
    public int getWsPingPeriod() {
        return this.wsPingPeriod;
    }

    @Generated
    public int getWsCloseDelay() {
        return this.wsCloseDelay;
    }

    @Generated
    public IBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    @Generated
    public boolean isVerifyChatAccountOnReconnect() {
        return this.verifyChatAccountOnReconnect;
    }

    @Generated
    public MirroredMessagePolicy getMirroredMessagePolicy() {
        return this.mirroredMessagePolicy;
    }

    @Generated
    public Predicate<String> getJoinedToRoomId() {
        return this.joinedToRoomId;
    }

    @Generated
    public Cache<String, Boolean> getObservedMessageIds() {
        return this.observedMessageIds;
    }

    @Generated
    private TwitchChatBuilder() {
    }

    @Generated
    private TwitchChatBuilder(WebsocketConnection websocketConnection, String clientId, String clientSecret, Integer requestQueueSize, EventManager eventManager, Class<? extends IEventHandler> defaultEventHandler, CredentialManager credentialManager, OAuth2Credential chatAccount, String baseUrl, boolean sendCredentialToThirdPartyHost, Collection<String> botOwnerIds, Set<String> commandPrefixes, Integer chatQueueSize, Bandwidth chatRateLimit, Bandwidth[] whisperRateLimit, Bandwidth joinRateLimit, Bandwidth authRateLimit, Bandwidth perChannelRateLimit, Bucket ircMessageBucket, Bucket ircWhisperBucket, Bucket ircJoinBucket, Bucket ircAuthBucket, ScheduledThreadPoolExecutor scheduledThreadPoolExecutor, long chatQueueTimeout, ProxyConfig proxyConfig, boolean autoJoinOwnChannel, boolean enableMembershipEvents, boolean removeChannelOnJoinFailure, int maxJoinRetries, long chatJoinTimeout, int wsPingPeriod, int wsCloseDelay, IBackoffStrategy connectionBackoffStrategy, boolean verifyChatAccountOnReconnect, BiPredicate<TwitchChat, String> outboundCommandFilter, MirroredMessagePolicy mirroredMessagePolicy, Predicate<String> joinedToRoomId, Cache<String, Boolean> observedMessageIds) {
        this.websocketConnection = websocketConnection;
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.requestQueueSize = requestQueueSize;
        this.eventManager = eventManager;
        this.defaultEventHandler = defaultEventHandler;
        this.credentialManager = credentialManager;
        this.chatAccount = chatAccount;
        this.baseUrl = baseUrl;
        this.sendCredentialToThirdPartyHost = sendCredentialToThirdPartyHost;
        this.botOwnerIds = botOwnerIds;
        this.commandPrefixes = commandPrefixes;
        this.chatQueueSize = chatQueueSize;
        this.chatRateLimit = chatRateLimit;
        this.whisperRateLimit = whisperRateLimit;
        this.joinRateLimit = joinRateLimit;
        this.authRateLimit = authRateLimit;
        this.perChannelRateLimit = perChannelRateLimit;
        this.ircMessageBucket = ircMessageBucket;
        this.ircWhisperBucket = ircWhisperBucket;
        this.ircJoinBucket = ircJoinBucket;
        this.ircAuthBucket = ircAuthBucket;
        this.scheduledThreadPoolExecutor = scheduledThreadPoolExecutor;
        this.chatQueueTimeout = chatQueueTimeout;
        this.proxyConfig = proxyConfig;
        this.autoJoinOwnChannel = autoJoinOwnChannel;
        this.enableMembershipEvents = enableMembershipEvents;
        this.removeChannelOnJoinFailure = removeChannelOnJoinFailure;
        this.maxJoinRetries = maxJoinRetries;
        this.chatJoinTimeout = chatJoinTimeout;
        this.wsPingPeriod = wsPingPeriod;
        this.wsCloseDelay = wsCloseDelay;
        this.connectionBackoffStrategy = connectionBackoffStrategy;
        this.verifyChatAccountOnReconnect = verifyChatAccountOnReconnect;
        this.outboundCommandFilter = outboundCommandFilter;
        this.mirroredMessagePolicy = mirroredMessagePolicy;
        this.joinedToRoomId = joinedToRoomId;
        this.observedMessageIds = observedMessageIds;
    }

    @Generated
    protected TwitchChatBuilder withWebsocketConnection(WebsocketConnection websocketConnection) {
        return this.websocketConnection == websocketConnection ? this : new TwitchChatBuilder(websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchChatBuilder(this.websocketConnection, clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withEventManager(EventManager eventManager) {
        return this.eventManager == eventManager ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withDefaultEventHandler(Class<? extends IEventHandler> defaultEventHandler) {
        return this.defaultEventHandler == defaultEventHandler ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withCredentialManager(CredentialManager credentialManager) {
        return this.credentialManager == credentialManager ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withChatAccount(OAuth2Credential chatAccount) {
        return this.chatAccount == chatAccount ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withSendCredentialToThirdPartyHost(boolean sendCredentialToThirdPartyHost) {
        return this.sendCredentialToThirdPartyHost == sendCredentialToThirdPartyHost ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder setBotOwnerIds(Collection<String> botOwnerIds) {
        this.botOwnerIds = botOwnerIds;
        return this;
    }

    @Generated
    public TwitchChatBuilder setCommandPrefixes(Set<String> commandPrefixes) {
        this.commandPrefixes = commandPrefixes;
        return this;
    }

    @Generated
    public TwitchChatBuilder withChatQueueSize(Integer chatQueueSize) {
        return this.chatQueueSize == chatQueueSize ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withChatRateLimit(Bandwidth chatRateLimit) {
        return this.chatRateLimit == chatRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Deprecated
    @Generated
    public TwitchChatBuilder withWhisperRateLimit(Bandwidth[] whisperRateLimit) {
        return this.whisperRateLimit == whisperRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withJoinRateLimit(Bandwidth joinRateLimit) {
        return this.joinRateLimit == joinRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withAuthRateLimit(Bandwidth authRateLimit) {
        return this.authRateLimit == authRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withPerChannelRateLimit(Bandwidth perChannelRateLimit) {
        return this.perChannelRateLimit == perChannelRateLimit ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withIrcMessageBucket(Bucket ircMessageBucket) {
        return this.ircMessageBucket == ircMessageBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Deprecated
    @Generated
    public TwitchChatBuilder withIrcWhisperBucket(Bucket ircWhisperBucket) {
        return this.ircWhisperBucket == ircWhisperBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withIrcJoinBucket(Bucket ircJoinBucket) {
        return this.ircJoinBucket == ircJoinBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withIrcAuthBucket(Bucket ircAuthBucket) {
        return this.ircAuthBucket == ircAuthBucket ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withScheduledThreadPoolExecutor(ScheduledThreadPoolExecutor scheduledThreadPoolExecutor) {
        return this.scheduledThreadPoolExecutor == scheduledThreadPoolExecutor ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withChatQueueTimeout(long chatQueueTimeout) {
        return this.chatQueueTimeout == chatQueueTimeout ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withAutoJoinOwnChannel(boolean autoJoinOwnChannel) {
        return this.autoJoinOwnChannel == autoJoinOwnChannel ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withEnableMembershipEvents(boolean enableMembershipEvents) {
        return this.enableMembershipEvents == enableMembershipEvents ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withRemoveChannelOnJoinFailure(boolean removeChannelOnJoinFailure) {
        return this.removeChannelOnJoinFailure == removeChannelOnJoinFailure ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withMaxJoinRetries(int maxJoinRetries) {
        return this.maxJoinRetries == maxJoinRetries ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withChatJoinTimeout(long chatJoinTimeout) {
        return this.chatJoinTimeout == chatJoinTimeout ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withWsPingPeriod(int wsPingPeriod) {
        return this.wsPingPeriod == wsPingPeriod ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withWsCloseDelay(int wsCloseDelay) {
        return this.wsCloseDelay == wsCloseDelay ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withConnectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
        return this.connectionBackoffStrategy == connectionBackoffStrategy ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withVerifyChatAccountOnReconnect(boolean verifyChatAccountOnReconnect) {
        return this.verifyChatAccountOnReconnect == verifyChatAccountOnReconnect ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    private BiPredicate<TwitchChat, String> getOutboundCommandFilter() {
        return this.outboundCommandFilter;
    }

    @Deprecated
    @ApiStatus.Internal
    @Generated
    public TwitchChatBuilder withOutboundCommandFilter(BiPredicate<TwitchChat, String> outboundCommandFilter) {
        return this.outboundCommandFilter == outboundCommandFilter ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @Generated
    public TwitchChatBuilder withMirroredMessagePolicy(MirroredMessagePolicy mirroredMessagePolicy) {
        return this.mirroredMessagePolicy == mirroredMessagePolicy ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, mirroredMessagePolicy, this.joinedToRoomId, this.observedMessageIds);
    }

    @ApiStatus.Internal
    @Generated
    public TwitchChatBuilder withJoinedToRoomId(Predicate<String> joinedToRoomId) {
        return this.joinedToRoomId == joinedToRoomId ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, joinedToRoomId, this.observedMessageIds);
    }

    @ApiStatus.Internal
    @Generated
    public TwitchChatBuilder withObservedMessageIds(Cache<String, Boolean> observedMessageIds) {
        return this.observedMessageIds == observedMessageIds ? this : new TwitchChatBuilder(this.websocketConnection, this.clientId, this.clientSecret, this.requestQueueSize, this.eventManager, this.defaultEventHandler, this.credentialManager, this.chatAccount, this.baseUrl, this.sendCredentialToThirdPartyHost, this.botOwnerIds, this.commandPrefixes, this.chatQueueSize, this.chatRateLimit, this.whisperRateLimit, this.joinRateLimit, this.authRateLimit, this.perChannelRateLimit, this.ircMessageBucket, this.ircWhisperBucket, this.ircJoinBucket, this.ircAuthBucket, this.scheduledThreadPoolExecutor, this.chatQueueTimeout, this.proxyConfig, this.autoJoinOwnChannel, this.enableMembershipEvents, this.removeChannelOnJoinFailure, this.maxJoinRetries, this.chatJoinTimeout, this.wsPingPeriod, this.wsCloseDelay, this.connectionBackoffStrategy, this.verifyChatAccountOnReconnect, this.outboundCommandFilter, this.mirroredMessagePolicy, this.joinedToRoomId, observedMessageIds);
    }
}

