/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.morelaid.streamingmodule.external.twitch4j.chat.ITwitchChat;
import com.morelaid.streamingmodule.external.twitch4j.chat.TwitchChat;
import com.morelaid.streamingmodule.external.twitch4j.chat.TwitchChatBuilder;
import com.morelaid.streamingmodule.external.twitch4j.chat.enums.MirroredMessagePolicy;
import com.morelaid.streamingmodule.external.twitch4j.chat.enums.NoticeTag;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ChannelJoinFailureEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ChannelNoticeEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ChannelStateEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.util.TwitchChatLimitHelper;
import com.morelaid.streamingmodule.external.twitch4j.common.config.ProxyConfig;
import com.morelaid.streamingmodule.external.twitch4j.common.pool.TwitchModuleConnectionPool;
import com.morelaid.streamingmodule.external.twitch4j.common.util.BucketUtils;
import com.morelaid.streamingmodule.external.twitch4j.common.util.CryptoUtils;
import com.morelaid.streamingmodule.external.twitch4j.util.IBackoffStrategy;
import io.github.bucket4j.Bandwidth;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.Nullable;

public class TwitchChatConnectionPool
extends TwitchModuleConnectionPool<TwitchChat, String, String, Boolean, TwitchChatBuilder>
implements ITwitchChat {
    private final String threadPrefix = "twitch4j-pool-" + CryptoUtils.generateNonce(4) + "-chat-";
    @NonNull
    protected final Supplier<OAuth2Credential> chatAccount;
    @Deprecated
    protected final boolean automaticallyPartOnBan;
    protected Bandwidth chatRateLimit;
    protected Bandwidth[] whisperRateLimit;
    protected Bandwidth joinRateLimit;
    protected Bandwidth authRateLimit;
    protected Bandwidth perChannelRateLimit;
    private IBackoffStrategy connectionBackoffStrategy;
    private MirroredMessagePolicy mirroredMessagePolicy;
    private volatile Cache<String, Boolean> observedMessageIds;
    private final Set<String> joinedRoomIds = ConcurrentHashMap.newKeySet();

    @Override
    public boolean sendMessage(String channel, String message, @Nullable Map<String, Object> tags) {
        return this.sendMessage(channel, channel, message, tags);
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message) {
        return this.sendMessage(channelToIdentifyChatInstance, targetChannel, message, Collections.emptyMap());
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message, String nonce, String replyMsgId) {
        LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
        if (nonce != null) {
            tags.put("client-nonce", nonce);
        }
        if (replyMsgId != null) {
            tags.put("reply-parent-msg-id", replyMsgId);
        }
        return this.sendMessage(channelToIdentifyChatInstance, targetChannel, message, tags);
    }

    public boolean sendMessage(String channelToIdentifyChatInstance, String targetChannel, String message, @Nullable Map<String, Object> tags) {
        if (channelToIdentifyChatInstance == null) {
            return false;
        }
        TwitchChat chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase());
        if (chat == null) {
            return false;
        }
        if (targetChannel != null) {
            chat.sendMessage(targetChannel, message, tags);
        } else {
            chat.sendRaw(message);
        }
        return true;
    }

    @Deprecated
    public boolean sendPrivateMessage(String channelToIdentifyChatInstance, String toChannel, String message) {
        TwitchChat chat;
        if (channelToIdentifyChatInstance == null || (chat = (TwitchChat)this.subscriptions.get(channelToIdentifyChatInstance.toLowerCase())) == null) {
            return false;
        }
        chat.sendPrivateMessage(toChannel, message);
        return true;
    }

    @Override
    public String subscribe(String s2) {
        return s2 != null ? (String)super.subscribe(s2.toLowerCase()) : null;
    }

    @Override
    public void joinChannel(String channelName) {
        this.subscribe(channelName);
    }

    @Override
    public Boolean unsubscribe(String s2) {
        String roomId;
        ITwitchChat chat;
        String key;
        String string = key = s2 != null ? s2.toLowerCase() : null;
        if (this.mirroredMessagePolicy == MirroredMessagePolicy.REJECT_IF_OBSERVED && (chat = (ITwitchChat)this.subscriptions.get(key)) != null && (roomId = chat.getChannelNameToChannelId().get(key)) != null) {
            this.joinedRoomIds.remove(roomId);
        }
        return (Boolean)super.unsubscribe(key);
    }

    @Override
    public boolean leaveChannel(String channelName) {
        Boolean b = this.unsubscribe(channelName);
        return b != null && b != false;
    }

    @Override
    public boolean isChannelJoined(String channelName) {
        return this.subscriptions.containsKey(channelName.toLowerCase());
    }

    @Override
    public Set<String> getChannels() {
        return Collections.unmodifiableSet(this.subscriptions.keySet());
    }

    @Override
    protected String handleSubscription(TwitchChat twitchChat, String s2) {
        if (twitchChat == null) {
            return null;
        }
        twitchChat.joinChannel(s2);
        return s2;
    }

    @Override
    protected String handleDuplicateSubscription(TwitchChat twitchChat, TwitchChat old, String s2) {
        return twitchChat != null && twitchChat != old && twitchChat.leaveChannel(s2) ? s2 : null;
    }

    @Override
    protected Boolean handleUnsubscription(TwitchChat twitchChat, String s2) {
        return twitchChat != null ? Boolean.valueOf(twitchChat.leaveChannel(s2)) : null;
    }

    @Override
    protected String getRequestFromSubscription(String s2) {
        return s2;
    }

    @Override
    protected int getSubscriptionSize(String s2) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected TwitchChat createConnection() {
        if (this.closed.get()) {
            throw new IllegalStateException("Chat socket cannot be created after pool was closed!");
        }
        if (this.mirroredMessagePolicy == MirroredMessagePolicy.REJECT_IF_OBSERVED && this.observedMessageIds == null) {
            TwitchChatConnectionPool twitchChatConnectionPool = this;
            synchronized (twitchChatConnectionPool) {
                if (this.observedMessageIds == null) {
                    this.observedMessageIds = CacheApi.create(spec -> {
                        spec.expiryTime(Duration.ofSeconds(10L));
                        spec.expiryType(ExpiryType.POST_WRITE);
                        spec.maxSize(2048L);
                    });
                }
            }
        }
        TwitchChat chat = ((TwitchChatBuilder)this.advancedConfiguration.apply(TwitchChatBuilder.builder().withChatAccount(this.chatAccount.get()).withEventManager(this.getConnectionEventManager()).withScheduledThreadPoolExecutor(this.getExecutor(this.threadPrefix + CryptoUtils.generateNonce(4), 2)).withProxyConfig((ProxyConfig)this.proxyConfig.get()).withChatRateLimit(this.chatRateLimit).withWhisperRateLimit(this.whisperRateLimit).withJoinRateLimit(this.joinRateLimit).withAuthRateLimit(this.authRateLimit).withPerChannelRateLimit(this.perChannelRateLimit).withAutoJoinOwnChannel(false).withConnectionBackoffStrategy(this.connectionBackoffStrategy).withJoinedToRoomId(this.joinedRoomIds::contains).withMirroredMessagePolicy(this.mirroredMessagePolicy).withObservedMessageIds(this.observedMessageIds))).build();
        if (this.mirroredMessagePolicy == MirroredMessagePolicy.REJECT_IF_OBSERVED) {
            chat.getEventManager().onEvent(this.threadPrefix + "room-tracker", ChannelStateEvent.class, e -> this.joinedRoomIds.add(e.getChannel().getId()));
        }
        chat.getEventManager().onEvent(this.threadPrefix + "join-fail-tracker", ChannelJoinFailureEvent.class, e -> this.unsubscribe(e.getChannelName()));
        chat.getEventManager().onEvent(this.threadPrefix + "ban-tracker", ChannelNoticeEvent.class, e -> {
            if (this.automaticallyPartOnBan && NoticeTag.MSG_BANNED.toString().equals(e.getMsgId())) {
                this.unsubscribe(e.getChannel().getName());
            }
        });
        return chat;
    }

    @Override
    protected void disposeConnection(TwitchChat connection) {
        connection.close();
    }

    @Override
    public long getLatency() {
        long sum = 0L;
        int count = 0;
        for (TwitchChat connection : this.getConnections()) {
            long latency = connection.getLatency();
            if (latency <= 0L) continue;
            sum += latency;
            ++count;
        }
        return count > 0 ? sum / (long)count : -1L;
    }

    @Override
    public Map<String, String> getChannelIdToChannelName() {
        return this.collectMapsFromConnections(TwitchChat::getChannelIdToChannelName);
    }

    @Override
    public Map<String, String> getChannelNameToChannelId() {
        return this.collectMapsFromConnections(TwitchChat::getChannelNameToChannelId);
    }

    private <K, V> Map<K, V> collectMapsFromConnections(Function<TwitchChat, Map<K, V>> mapRetriever) {
        HashMap aggregated = new HashMap(this.numConnections() * this.maxSubscriptionsPerConnection);
        Consumer<TwitchChat> retrieve = chat -> aggregated.putAll((Map)mapRetriever.apply((TwitchChat)chat));
        this.saturatedConnections.forEach(retrieve);
        this.unsaturatedConnections.keySet().forEach(retrieve);
        return Collections.unmodifiableMap(aggregated);
    }

    @Generated
    private static Supplier<OAuth2Credential> $default$chatAccount() {
        return () -> null;
    }

    @Generated
    private static boolean $default$automaticallyPartOnBan() {
        return false;
    }

    @Generated
    private static Bandwidth $default$chatRateLimit() {
        return TwitchChatLimitHelper.USER_MESSAGE_LIMIT;
    }

    @Generated
    private static Bandwidth[] $default$whisperRateLimit() {
        return TwitchChatLimitHelper.USER_WHISPER_LIMIT.toArray(new Bandwidth[2]);
    }

    @Generated
    private static Bandwidth $default$joinRateLimit() {
        return TwitchChatLimitHelper.USER_JOIN_LIMIT;
    }

    @Generated
    private static Bandwidth $default$authRateLimit() {
        return TwitchChatLimitHelper.USER_AUTH_LIMIT;
    }

    @Generated
    private static Bandwidth $default$perChannelRateLimit() {
        return BucketUtils.simple(100L, Duration.ofSeconds(30L), "per-channel-limit");
    }

    @Generated
    private static IBackoffStrategy $default$connectionBackoffStrategy() {
        return null;
    }

    @Generated
    private static MirroredMessagePolicy $default$mirroredMessagePolicy() {
        return MirroredMessagePolicy.REJECT_IF_OBSERVED;
    }

    @Generated
    protected TwitchChatConnectionPool(TwitchChatConnectionPoolBuilder<?, ?> b) {
        super(b);
        this.chatAccount = ((TwitchChatConnectionPoolBuilder)b).chatAccount$set ? ((TwitchChatConnectionPoolBuilder)b).chatAccount$value : TwitchChatConnectionPool.$default$chatAccount();
        if (this.chatAccount == null) {
            throw new NullPointerException("chatAccount is marked non-null but is null");
        }
        this.automaticallyPartOnBan = ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$set ? ((TwitchChatConnectionPoolBuilder)b).automaticallyPartOnBan$value : TwitchChatConnectionPool.$default$automaticallyPartOnBan();
        this.chatRateLimit = ((TwitchChatConnectionPoolBuilder)b).chatRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).chatRateLimit$value : TwitchChatConnectionPool.$default$chatRateLimit();
        this.whisperRateLimit = ((TwitchChatConnectionPoolBuilder)b).whisperRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).whisperRateLimit$value : TwitchChatConnectionPool.$default$whisperRateLimit();
        this.joinRateLimit = ((TwitchChatConnectionPoolBuilder)b).joinRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).joinRateLimit$value : TwitchChatConnectionPool.$default$joinRateLimit();
        this.authRateLimit = ((TwitchChatConnectionPoolBuilder)b).authRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).authRateLimit$value : TwitchChatConnectionPool.$default$authRateLimit();
        this.perChannelRateLimit = ((TwitchChatConnectionPoolBuilder)b).perChannelRateLimit$set ? ((TwitchChatConnectionPoolBuilder)b).perChannelRateLimit$value : TwitchChatConnectionPool.$default$perChannelRateLimit();
        this.connectionBackoffStrategy = ((TwitchChatConnectionPoolBuilder)b).connectionBackoffStrategy$set ? ((TwitchChatConnectionPoolBuilder)b).connectionBackoffStrategy$value : TwitchChatConnectionPool.$default$connectionBackoffStrategy();
        this.mirroredMessagePolicy = ((TwitchChatConnectionPoolBuilder)b).mirroredMessagePolicy$set ? ((TwitchChatConnectionPoolBuilder)b).mirroredMessagePolicy$value : TwitchChatConnectionPool.$default$mirroredMessagePolicy();
        this.observedMessageIds = ((TwitchChatConnectionPoolBuilder)b).observedMessageIds;
    }

    @Generated
    public static TwitchChatConnectionPoolBuilder<?, ?> builder() {
        return new TwitchChatConnectionPoolBuilderImpl();
    }

    @Generated
    public static abstract class TwitchChatConnectionPoolBuilder<C extends TwitchChatConnectionPool, B extends TwitchChatConnectionPoolBuilder<C, B>>
    extends TwitchModuleConnectionPool.TwitchModuleConnectionPoolBuilder<TwitchChat, String, String, Boolean, TwitchChatBuilder, C, B> {
        @Generated
        private boolean chatAccount$set;
        @Generated
        private Supplier<OAuth2Credential> chatAccount$value;
        @Generated
        private boolean automaticallyPartOnBan$set;
        @Generated
        private boolean automaticallyPartOnBan$value;
        @Generated
        private boolean chatRateLimit$set;
        @Generated
        private Bandwidth chatRateLimit$value;
        @Generated
        private boolean whisperRateLimit$set;
        @Generated
        private Bandwidth[] whisperRateLimit$value;
        @Generated
        private boolean joinRateLimit$set;
        @Generated
        private Bandwidth joinRateLimit$value;
        @Generated
        private boolean authRateLimit$set;
        @Generated
        private Bandwidth authRateLimit$value;
        @Generated
        private boolean perChannelRateLimit$set;
        @Generated
        private Bandwidth perChannelRateLimit$value;
        @Generated
        private boolean connectionBackoffStrategy$set;
        @Generated
        private IBackoffStrategy connectionBackoffStrategy$value;
        @Generated
        private boolean mirroredMessagePolicy$set;
        @Generated
        private MirroredMessagePolicy mirroredMessagePolicy$value;
        @Generated
        private Cache<String, Boolean> observedMessageIds;

        @Generated
        public B chatAccount(@NonNull Supplier<OAuth2Credential> chatAccount) {
            if (chatAccount == null) {
                throw new NullPointerException("chatAccount is marked non-null but is null");
            }
            this.chatAccount$value = chatAccount;
            this.chatAccount$set = true;
            return (B)this.self();
        }

        @Deprecated
        @Generated
        public B automaticallyPartOnBan(boolean automaticallyPartOnBan) {
            this.automaticallyPartOnBan$value = automaticallyPartOnBan;
            this.automaticallyPartOnBan$set = true;
            return (B)this.self();
        }

        @Generated
        public B chatRateLimit(Bandwidth chatRateLimit) {
            this.chatRateLimit$value = chatRateLimit;
            this.chatRateLimit$set = true;
            return (B)this.self();
        }

        @Generated
        public B whisperRateLimit(Bandwidth[] whisperRateLimit) {
            this.whisperRateLimit$value = whisperRateLimit;
            this.whisperRateLimit$set = true;
            return (B)this.self();
        }

        @Generated
        public B joinRateLimit(Bandwidth joinRateLimit) {
            this.joinRateLimit$value = joinRateLimit;
            this.joinRateLimit$set = true;
            return (B)this.self();
        }

        @Generated
        public B authRateLimit(Bandwidth authRateLimit) {
            this.authRateLimit$value = authRateLimit;
            this.authRateLimit$set = true;
            return (B)this.self();
        }

        @Generated
        public B perChannelRateLimit(Bandwidth perChannelRateLimit) {
            this.perChannelRateLimit$value = perChannelRateLimit;
            this.perChannelRateLimit$set = true;
            return (B)this.self();
        }

        @Generated
        public B connectionBackoffStrategy(IBackoffStrategy connectionBackoffStrategy) {
            this.connectionBackoffStrategy$value = connectionBackoffStrategy;
            this.connectionBackoffStrategy$set = true;
            return (B)this.self();
        }

        @Generated
        public B mirroredMessagePolicy(MirroredMessagePolicy mirroredMessagePolicy) {
            this.mirroredMessagePolicy$value = mirroredMessagePolicy;
            this.mirroredMessagePolicy$set = true;
            return (B)this.self();
        }

        @Generated
        public B observedMessageIds(Cache<String, Boolean> observedMessageIds) {
            this.observedMessageIds = observedMessageIds;
            return (B)this.self();
        }

        @Override
        @Generated
        protected abstract B self();

        @Override
        @Generated
        public abstract C build();

        @Override
        @Generated
        public String toString() {
            return "TwitchChatConnectionPool.TwitchChatConnectionPoolBuilder(super=" + super.toString() + ", chatAccount$value=" + this.chatAccount$value + ", automaticallyPartOnBan$value=" + this.automaticallyPartOnBan$value + ", chatRateLimit$value=" + this.chatRateLimit$value + ", whisperRateLimit$value=" + Arrays.deepToString(this.whisperRateLimit$value) + ", joinRateLimit$value=" + this.joinRateLimit$value + ", authRateLimit$value=" + this.authRateLimit$value + ", perChannelRateLimit$value=" + this.perChannelRateLimit$value + ", connectionBackoffStrategy$value=" + this.connectionBackoffStrategy$value + ", mirroredMessagePolicy$value=" + (Object)((Object)this.mirroredMessagePolicy$value) + ", observedMessageIds=" + this.observedMessageIds + ")";
        }
    }

    @Generated
    private static final class TwitchChatConnectionPoolBuilderImpl
    extends TwitchChatConnectionPoolBuilder<TwitchChatConnectionPool, TwitchChatConnectionPoolBuilderImpl> {
        @Generated
        private TwitchChatConnectionPoolBuilderImpl() {
        }

        @Override
        @Generated
        protected TwitchChatConnectionPoolBuilderImpl self() {
            return this;
        }

        @Override
        @Generated
        public TwitchChatConnectionPool build() {
            return new TwitchChatConnectionPool(this);
        }
    }
}

