/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat.events;

import com.morelaid.streamingmodule.external.twitch4j.chat.enums.CommandSource;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.CommandPermission;
import com.morelaid.streamingmodule.external.twitch4j.common.events.domain.EventUser;
import java.util.Set;
import lombok.Generated;

public final class CommandEvent
extends TwitchEvent {
    private final CommandSource source;
    private final String sourceId;
    private final EventUser user;
    private final String commandPrefix;
    private final String command;
    private final Set<CommandPermission> permissions;

    public CommandEvent(CommandSource source2, String sourceId, EventUser user, String commandPrefix, String command, Set<CommandPermission> permissions) {
        this.source = source2;
        this.sourceId = sourceId;
        this.user = user;
        this.commandPrefix = commandPrefix;
        this.command = command;
        this.permissions = permissions;
    }

    public void respondToUser(String message) {
        if (this.source.equals((Object)CommandSource.CHANNEL)) {
            this.getTwitchChat().sendMessage(this.sourceId, message);
        } else if (this.source.equals((Object)CommandSource.PRIVATE_MESSAGE)) {
            this.getTwitchChat().sendMessage(this.sourceId, "/w " + this.sourceId + " " + message);
        }
    }

    @Override
    @Generated
    public String toString() {
        return "CommandEvent(source=" + (Object)((Object)this.getSource()) + ", sourceId=" + this.getSourceId() + ", user=" + this.getUser() + ", commandPrefix=" + this.getCommandPrefix() + ", command=" + this.getCommand() + ", permissions=" + this.getPermissions() + ")";
    }

    @Generated
    public CommandSource getSource() {
        return this.source;
    }

    @Generated
    public String getSourceId() {
        return this.sourceId;
    }

    @Generated
    public EventUser getUser() {
        return this.user;
    }

    @Generated
    public String getCommandPrefix() {
        return this.commandPrefix;
    }

    @Generated
    public String getCommand() {
        return this.command;
    }

    @Generated
    public Set<CommandPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CommandEvent)) {
            return false;
        }
        CommandEvent other = (CommandEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CommandSource this$source = this.getSource();
        CommandSource other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)((Object)this$source)).equals((Object)other$source)) {
            return false;
        }
        String this$sourceId = this.getSourceId();
        String other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !this$sourceId.equals(other$sourceId)) {
            return false;
        }
        EventUser this$user = this.getUser();
        EventUser other$user = other.getUser();
        if (this$user == null ? other$user != null : !((Object)this$user).equals(other$user)) {
            return false;
        }
        String this$commandPrefix = this.getCommandPrefix();
        String other$commandPrefix = other.getCommandPrefix();
        if (this$commandPrefix == null ? other$commandPrefix != null : !this$commandPrefix.equals(other$commandPrefix)) {
            return false;
        }
        String this$command = this.getCommand();
        String other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) {
            return false;
        }
        Set<CommandPermission> this$permissions = this.getPermissions();
        Set<CommandPermission> other$permissions = other.getPermissions();
        return !(this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CommandEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CommandSource $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)((Object)$source)).hashCode());
        String $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : $sourceId.hashCode());
        EventUser $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : ((Object)$user).hashCode());
        String $commandPrefix = this.getCommandPrefix();
        result = result * 59 + ($commandPrefix == null ? 43 : $commandPrefix.hashCode());
        String $command = this.getCommand();
        result = result * 59 + ($command == null ? 43 : $command.hashCode());
        Set<CommandPermission> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        return result;
    }
}

