/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat.events.channel;

import com.morelaid.streamingmodule.external.twitch4j.chat.events.AbstractChannelEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.IRCMessageEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.CommandPermission;
import com.morelaid.streamingmodule.external.twitch4j.common.events.domain.EventUser;
import com.morelaid.streamingmodule.external.twitch4j.common.util.DonationAmount;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;

public final class CharityDonationEvent
extends AbstractChannelEvent {
    @NotNull
    private final IRCMessageEvent messageEvent;
    private final String userId;
    private final String userLogin;
    private final String userName;
    private final Set<CommandPermission> badges;
    private final String charityName;
    private final DonationAmount amount;
    private final String systemMessage;

    public CharityDonationEvent(@NotNull IRCMessageEvent rawEvent) {
        super(rawEvent.getChannel());
        this.messageEvent = rawEvent;
        this.userId = rawEvent.getTagValue("user-id").orElse(null);
        this.userLogin = rawEvent.getTagValue("login").orElse(null);
        this.userName = rawEvent.getTagValue("display-name").orElse(this.userLogin);
        this.badges = rawEvent.getClientPermissions();
        this.charityName = rawEvent.getTagValue("msg-param-charity-name").orElse(null);
        Long amount = Long.parseLong(rawEvent.getTagValue("msg-param-donation-amount").orElse("0"));
        String currency = rawEvent.getTagValue("msg-param-donation-currency").orElse("USD");
        Integer decimals = Integer.parseInt(rawEvent.getTagValue("msg-param-exponent").orElse("2"));
        this.amount = new DonationAmount(amount, decimals, currency);
        this.systemMessage = rawEvent.getTagValue("system-msg").orElseGet(() -> String.format("%s donated %s %s to support %s", this.userName, currency, this.amount.getParsedValue().toPlainString(), this.charityName));
    }

    public EventUser getUser() {
        return new EventUser(this.userId, this.userLogin);
    }

    @NotNull
    @Generated
    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    @Generated
    public String getUserId() {
        return this.userId;
    }

    @Generated
    public String getUserLogin() {
        return this.userLogin;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public Set<CommandPermission> getBadges() {
        return this.badges;
    }

    @Generated
    public String getCharityName() {
        return this.charityName;
    }

    @Generated
    public DonationAmount getAmount() {
        return this.amount;
    }

    @Generated
    public String getSystemMessage() {
        return this.systemMessage;
    }

    @Override
    @Generated
    public String toString() {
        return "CharityDonationEvent(messageEvent=" + this.getMessageEvent() + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", userName=" + this.getUserName() + ", badges=" + this.getBadges() + ", charityName=" + this.getCharityName() + ", amount=" + this.getAmount() + ", systemMessage=" + this.getSystemMessage() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CharityDonationEvent)) {
            return false;
        }
        CharityDonationEvent other = (CharityDonationEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userLogin = this.getUserLogin();
        String other$userLogin = other.getUserLogin();
        if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        Set<CommandPermission> this$badges = this.getBadges();
        Set<CommandPermission> other$badges = other.getBadges();
        if (this$badges == null ? other$badges != null : !((Object)this$badges).equals(other$badges)) {
            return false;
        }
        String this$charityName = this.getCharityName();
        String other$charityName = other.getCharityName();
        if (this$charityName == null ? other$charityName != null : !this$charityName.equals(other$charityName)) {
            return false;
        }
        DonationAmount this$amount = this.getAmount();
        DonationAmount other$amount = other.getAmount();
        if (this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount)) {
            return false;
        }
        String this$systemMessage = this.getSystemMessage();
        String other$systemMessage = other.getSystemMessage();
        return !(this$systemMessage == null ? other$systemMessage != null : !this$systemMessage.equals(other$systemMessage));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CharityDonationEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userLogin = this.getUserLogin();
        result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        Set<CommandPermission> $badges = this.getBadges();
        result = result * 59 + ($badges == null ? 43 : ((Object)$badges).hashCode());
        String $charityName = this.getCharityName();
        result = result * 59 + ($charityName == null ? 43 : $charityName.hashCode());
        DonationAmount $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        String $systemMessage = this.getSystemMessage();
        result = result * 59 + ($systemMessage == null ? 43 : $systemMessage.hashCode());
        return result;
    }
}

