/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat.events.channel;

import com.morelaid.streamingmodule.external.twitch4j.chat.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.IRCMessageEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.CommandPermission;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class GlobalUserStateEvent
extends TwitchEvent {
    private final IRCMessageEvent messageEvent;

    public Optional<String> getDisplayName() {
        return this.messageEvent.getTagValue("display-name");
    }

    public Optional<String> getUserId() {
        return Optional.ofNullable(this.messageEvent.getUserId());
    }

    public Optional<String> getColor() {
        return this.messageEvent.getUserChatColor();
    }

    public List<String> getEmoteSets() {
        return Collections.unmodifiableList(Arrays.asList(this.messageEvent.getTagValue("emote-sets").map(emoteSets -> StringUtils.split(emoteSets, ',')).orElse(new String[0])));
    }

    public boolean isStaff() {
        return this.messageEvent.getClientPermissions().contains((Object)CommandPermission.TWITCHSTAFF);
    }

    public boolean isPrimeOrTurbo() {
        return this.messageEvent.getClientPermissions().contains((Object)CommandPermission.PRIME_TURBO);
    }

    @Generated
    public GlobalUserStateEvent(IRCMessageEvent messageEvent) {
        this.messageEvent = messageEvent;
    }

    @Generated
    public IRCMessageEvent getMessageEvent() {
        return this.messageEvent;
    }

    @Override
    @Generated
    public String toString() {
        return "GlobalUserStateEvent(messageEvent=" + this.getMessageEvent() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalUserStateEvent)) {
            return false;
        }
        GlobalUserStateEvent other = (GlobalUserStateEvent)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IRCMessageEvent this$messageEvent = this.getMessageEvent();
        IRCMessageEvent other$messageEvent = other.getMessageEvent();
        return !(this$messageEvent == null ? other$messageEvent != null : !((Object)this$messageEvent).equals(other$messageEvent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlobalUserStateEvent;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IRCMessageEvent $messageEvent = this.getMessageEvent();
        result = result * 59 + ($messageEvent == null ? 43 : ((Object)$messageEvent).hashCode());
        return result;
    }
}

