/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.chat.util;

import com.morelaid.streamingmodule.external.twitch4j.common.enums.TwitchLimitType;
import com.morelaid.streamingmodule.external.twitch4j.common.util.BucketUtils;
import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.Bucket;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public final class TwitchChatLimitHelper {
    public static final String MESSAGE_BANDWIDTH_ID = TwitchLimitType.CHAT_MESSAGE_LIMIT.getBandwidthId();
    public static final String JOIN_BANDWIDTH_ID = TwitchLimitType.CHAT_JOIN_LIMIT.getBandwidthId();
    public static final String AUTH_BANDWIDTH_ID = TwitchLimitType.CHAT_AUTH_LIMIT.getBandwidthId();
    public static final String WHISPER_MINUTE_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-minute";
    public static final String WHISPER_SECOND_BANDWIDTH_ID = TwitchLimitType.CHAT_WHISPER_LIMIT.getBandwidthId() + "-second";
    public static final Bandwidth USER_MESSAGE_LIMIT = BucketUtils.simple(20L, Duration.ofSeconds(30L), MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth MOD_MESSAGE_LIMIT = BucketUtils.simple(100L, Duration.ofSeconds(30L), MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth KNOWN_MESSAGE_LIMIT = BucketUtils.simple(50L, Duration.ofSeconds(30L), MESSAGE_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_MESSAGE_LIMIT = BucketUtils.simple(7500L, Duration.ofSeconds(30L), MESSAGE_BANDWIDTH_ID);
    public static final List<Bandwidth> USER_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(BucketUtils.simple(100L, Duration.ofSeconds(60L), WHISPER_MINUTE_BANDWIDTH_ID), BucketUtils.simple(3L, Duration.ofSeconds(1L), WHISPER_SECOND_BANDWIDTH_ID)));
    public static final List<Bandwidth> KNOWN_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(BucketUtils.simple(200L, Duration.ofSeconds(60L), WHISPER_MINUTE_BANDWIDTH_ID), BucketUtils.simple(10L, Duration.ofSeconds(1L), WHISPER_SECOND_BANDWIDTH_ID)));
    public static final List<Bandwidth> VERIFIED_WHISPER_LIMIT = Collections.unmodifiableList(Arrays.asList(BucketUtils.simple(1200L, Duration.ofSeconds(60L), WHISPER_MINUTE_BANDWIDTH_ID), BucketUtils.simple(20L, Duration.ofSeconds(1L), WHISPER_SECOND_BANDWIDTH_ID)));
    public static final Bandwidth USER_JOIN_LIMIT = BucketUtils.simple(20L, Duration.ofSeconds(10L), JOIN_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_JOIN_LIMIT = BucketUtils.simple(2000L, Duration.ofSeconds(10L), JOIN_BANDWIDTH_ID);
    public static final Bandwidth USER_AUTH_LIMIT = BucketUtils.simple(20L, Duration.ofSeconds(10L), AUTH_BANDWIDTH_ID);
    public static final Bandwidth VERIFIED_AUTH_LIMIT = BucketUtils.simple(200L, Duration.ofSeconds(10L), AUTH_BANDWIDTH_ID);

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static Bucket createBucket(Bandwidth limit) {
        return BucketUtils.createBucket(limit);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static Bucket createBucket(Bandwidth ... limits) {
        return BucketUtils.createBucket(limits);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public static Bucket createBucket(Iterable<Bandwidth> limits) {
        return BucketUtils.createBucket(limits);
    }

    @Generated
    private TwitchChatLimitHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

