/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.common.enums;

import com.morelaid.streamingmodule.external.twitch4j.util.EnumUtil;
import java.time.Duration;
import java.util.Map;
import lombok.Generated;
import org.jetbrains.annotations.ApiStatus;

public enum HypeChatLevel {
    ONE(Duration.ofSeconds(30L)),
    TWO(Duration.ofSeconds(150L)),
    THREE(Duration.ofMinutes(5L)),
    FOUR(Duration.ofMinutes(10L)),
    FIVE(Duration.ofMinutes(30L)),
    SIX(Duration.ofHours(1L)),
    SEVEN(Duration.ofHours(2L)),
    EIGHT(Duration.ofHours(3L)),
    NINE(Duration.ofHours(4L)),
    TEN(Duration.ofHours(5L));

    @ApiStatus.Internal
    public static final Map<String, HypeChatLevel> MAPPINGS;
    private final Duration pinDuration;

    public int getLevel() {
        return this.ordinal() + 1;
    }

    public int getCharacterLimit() {
        return this.getLevel() * 50;
    }

    public boolean hasGradient() {
        return this.ordinal() >= SIX.ordinal();
    }

    @Generated
    private HypeChatLevel(Duration pinDuration) {
        this.pinDuration = pinDuration;
    }

    @Generated
    public Duration getPinDuration() {
        return this.pinDuration;
    }

    static {
        MAPPINGS = EnumUtil.buildMapping((Enum[])HypeChatLevel.values());
    }
}

