/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.common.util;

import com.morelaid.streamingmodule.external.twitch4j.util.IBackoffStrategy;
import java.time.Duration;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public final class ExponentialBackoffStrategy
implements IBackoffStrategy {
    private final long maximumBackoff;
    private final double multiplier;
    private final boolean immediateFirst;
    private final boolean jitter;
    private final long initialJitterRange;
    private final long baseMillis;
    private final int maxRetries;
    private final AtomicInteger failures = new AtomicInteger();

    @Override
    public long get() {
        int f = this.failures.getAndIncrement();
        if (this.maxRetries >= 0 && f >= this.maxRetries) {
            return -1L;
        }
        if (this.immediateFirst) {
            if (f == 0) {
                if (this.jitter) {
                    return ThreadLocalRandom.current().nextLong(this.initialJitterRange);
                }
                return 0L;
            }
            --f;
        }
        double delay = Math.pow(this.multiplier, f) * (double)this.baseMillis;
        if (this.maximumBackoff >= 0L) {
            delay = Math.min(delay, (double)this.maximumBackoff);
        }
        if (this.jitter && delay != 0.0) {
            delay *= 2.0;
            delay *= ThreadLocalRandom.current().nextDouble();
        }
        return Math.round(delay);
    }

    @Override
    public void reset() {
        this.setFailures(0);
    }

    public void setFailures(int failures) {
        this.failures.set(failures);
    }

    @Override
    public int getFailures() {
        return this.failures.get();
    }

    public ExponentialBackoffStrategy copy() {
        return this.toBuilder().build();
    }

    @Generated
    private static long $default$maximumBackoff() {
        return Duration.ofMinutes(2L).toMillis();
    }

    @Generated
    private static double $default$multiplier() {
        return 2.0;
    }

    @Generated
    private static boolean $default$immediateFirst() {
        return true;
    }

    @Generated
    private static boolean $default$jitter() {
        return true;
    }

    @Generated
    private static long $default$initialJitterRange() {
        return Duration.ofSeconds(5L).toMillis();
    }

    @Generated
    private static long $default$baseMillis() {
        return Duration.ofSeconds(1L).toMillis();
    }

    @Generated
    private static int $default$maxRetries() {
        return -1;
    }

    @Generated
    ExponentialBackoffStrategy(long maximumBackoff, double multiplier, boolean immediateFirst, boolean jitter, long initialJitterRange, long baseMillis, int maxRetries) {
        this.maximumBackoff = maximumBackoff;
        this.multiplier = multiplier;
        this.immediateFirst = immediateFirst;
        this.jitter = jitter;
        this.initialJitterRange = initialJitterRange;
        this.baseMillis = baseMillis;
        this.maxRetries = maxRetries;
    }

    @Generated
    public static ExponentialBackoffStrategyBuilder builder() {
        return new ExponentialBackoffStrategyBuilder();
    }

    @Generated
    public ExponentialBackoffStrategyBuilder toBuilder() {
        return new ExponentialBackoffStrategyBuilder().maximumBackoff(this.maximumBackoff).multiplier(this.multiplier).immediateFirst(this.immediateFirst).jitter(this.jitter).initialJitterRange(this.initialJitterRange).baseMillis(this.baseMillis).maxRetries(this.maxRetries);
    }

    @Generated
    public long getMaximumBackoff() {
        return this.maximumBackoff;
    }

    @Generated
    public double getMultiplier() {
        return this.multiplier;
    }

    @Generated
    public boolean isImmediateFirst() {
        return this.immediateFirst;
    }

    @Generated
    public boolean isJitter() {
        return this.jitter;
    }

    @Generated
    public long getInitialJitterRange() {
        return this.initialJitterRange;
    }

    @Generated
    public long getBaseMillis() {
        return this.baseMillis;
    }

    @Generated
    public int getMaxRetries() {
        return this.maxRetries;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExponentialBackoffStrategy)) {
            return false;
        }
        ExponentialBackoffStrategy other = (ExponentialBackoffStrategy)o;
        if (this.getMaximumBackoff() != other.getMaximumBackoff()) {
            return false;
        }
        if (Double.compare(this.getMultiplier(), other.getMultiplier()) != 0) {
            return false;
        }
        if (this.isImmediateFirst() != other.isImmediateFirst()) {
            return false;
        }
        if (this.isJitter() != other.isJitter()) {
            return false;
        }
        if (this.getInitialJitterRange() != other.getInitialJitterRange()) {
            return false;
        }
        if (this.getBaseMillis() != other.getBaseMillis()) {
            return false;
        }
        if (this.getMaxRetries() != other.getMaxRetries()) {
            return false;
        }
        return this.getFailures() == other.getFailures();
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $maximumBackoff = this.getMaximumBackoff();
        result = result * 59 + (int)($maximumBackoff >>> 32 ^ $maximumBackoff);
        long $multiplier = Double.doubleToLongBits(this.getMultiplier());
        result = result * 59 + (int)($multiplier >>> 32 ^ $multiplier);
        result = result * 59 + (this.isImmediateFirst() ? 79 : 97);
        result = result * 59 + (this.isJitter() ? 79 : 97);
        long $initialJitterRange = this.getInitialJitterRange();
        result = result * 59 + (int)($initialJitterRange >>> 32 ^ $initialJitterRange);
        long $baseMillis = this.getBaseMillis();
        result = result * 59 + (int)($baseMillis >>> 32 ^ $baseMillis);
        result = result * 59 + this.getMaxRetries();
        result = result * 59 + this.getFailures();
        return result;
    }

    @Generated
    public String toString() {
        return "ExponentialBackoffStrategy(maximumBackoff=" + this.getMaximumBackoff() + ", multiplier=" + this.getMultiplier() + ", immediateFirst=" + this.isImmediateFirst() + ", jitter=" + this.isJitter() + ", initialJitterRange=" + this.getInitialJitterRange() + ", baseMillis=" + this.getBaseMillis() + ", maxRetries=" + this.getMaxRetries() + ", failures=" + this.getFailures() + ")";
    }

    @Generated
    public static class ExponentialBackoffStrategyBuilder {
        @Generated
        private boolean maximumBackoff$set;
        @Generated
        private long maximumBackoff$value;
        @Generated
        private boolean multiplier$set;
        @Generated
        private double multiplier$value;
        @Generated
        private boolean immediateFirst$set;
        @Generated
        private boolean immediateFirst$value;
        @Generated
        private boolean jitter$set;
        @Generated
        private boolean jitter$value;
        @Generated
        private boolean initialJitterRange$set;
        @Generated
        private long initialJitterRange$value;
        @Generated
        private boolean baseMillis$set;
        @Generated
        private long baseMillis$value;
        @Generated
        private boolean maxRetries$set;
        @Generated
        private int maxRetries$value;

        @Generated
        ExponentialBackoffStrategyBuilder() {
        }

        @Generated
        public ExponentialBackoffStrategyBuilder maximumBackoff(long maximumBackoff) {
            this.maximumBackoff$value = maximumBackoff;
            this.maximumBackoff$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder multiplier(double multiplier) {
            this.multiplier$value = multiplier;
            this.multiplier$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder immediateFirst(boolean immediateFirst) {
            this.immediateFirst$value = immediateFirst;
            this.immediateFirst$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder jitter(boolean jitter) {
            this.jitter$value = jitter;
            this.jitter$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder initialJitterRange(long initialJitterRange) {
            this.initialJitterRange$value = initialJitterRange;
            this.initialJitterRange$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder baseMillis(long baseMillis) {
            this.baseMillis$value = baseMillis;
            this.baseMillis$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategyBuilder maxRetries(int maxRetries) {
            this.maxRetries$value = maxRetries;
            this.maxRetries$set = true;
            return this;
        }

        @Generated
        public ExponentialBackoffStrategy build() {
            long maximumBackoff$value = this.maximumBackoff$value;
            if (!this.maximumBackoff$set) {
                maximumBackoff$value = ExponentialBackoffStrategy.$default$maximumBackoff();
            }
            double multiplier$value = this.multiplier$value;
            if (!this.multiplier$set) {
                multiplier$value = ExponentialBackoffStrategy.$default$multiplier();
            }
            boolean immediateFirst$value = this.immediateFirst$value;
            if (!this.immediateFirst$set) {
                immediateFirst$value = ExponentialBackoffStrategy.$default$immediateFirst();
            }
            boolean jitter$value = this.jitter$value;
            if (!this.jitter$set) {
                jitter$value = ExponentialBackoffStrategy.$default$jitter();
            }
            long initialJitterRange$value = this.initialJitterRange$value;
            if (!this.initialJitterRange$set) {
                initialJitterRange$value = ExponentialBackoffStrategy.$default$initialJitterRange();
            }
            long baseMillis$value = this.baseMillis$value;
            if (!this.baseMillis$set) {
                baseMillis$value = ExponentialBackoffStrategy.$default$baseMillis();
            }
            int maxRetries$value = this.maxRetries$value;
            if (!this.maxRetries$set) {
                maxRetries$value = ExponentialBackoffStrategy.$default$maxRetries();
            }
            return new ExponentialBackoffStrategy(maximumBackoff$value, multiplier$value, immediateFirst$value, jitter$value, initialJitterRange$value, baseMillis$value, maxRetries$value);
        }

        @Generated
        public String toString() {
            return "ExponentialBackoffStrategy.ExponentialBackoffStrategyBuilder(maximumBackoff$value=" + this.maximumBackoff$value + ", multiplier$value=" + this.multiplier$value + ", immediateFirst$value=" + this.immediateFirst$value + ", jitter$value=" + this.jitter$value + ", initialJitterRange$value=" + this.initialJitterRange$value + ", baseMillis$value=" + this.baseMillis$value + ", maxRetries$value=" + this.maxRetries$value + ")";
        }
    }
}

