/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.extensions.compat;

import com.morelaid.streamingmodule.external.twitch4j.common.config.ProxyConfig;
import com.morelaid.streamingmodule.external.twitch4j.common.config.Twitch4JGlobal;
import com.morelaid.streamingmodule.external.twitch4j.extensions.TwitchExtensions;
import com.morelaid.streamingmodule.external.twitch4j.extensions.compat.ExtensionsTypeConverters;
import com.morelaid.streamingmodule.external.twitch4j.extensions.compat.HystrixCommandConverter;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ChannelList;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ConfigurationSegment;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ConfigurationSegmentType;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ExtensionConfigurationSegment;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ExtensionInformation;
import com.morelaid.streamingmodule.external.twitch4j.extensions.domain.ExtensionSecretList;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelix;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelixBuilder;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ExtensionConfigurationSegmentInput;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ExtensionConfigurationSegmentList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ExtensionLiveChannelsList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ExtensionSecretsList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ExtensionSegment;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ReleasedExtensionList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.SendPubSubMessageInput;
import com.netflix.hystrix.HystrixCommand;
import feign.Logger;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
public final class TwitchExtensionsCompatibilityLayer
implements TwitchExtensions {
    private final String clientId;
    private final TwitchHelix helix;

    public TwitchExtensionsCompatibilityLayer(String clientId, String clientSecret, String userAgent, Long timeout2, Integer requestQueueSize, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.helix = TwitchHelixBuilder.builder().withClientId(clientId).withClientSecret(clientSecret).withUserAgent(userAgent != null ? userAgent : Twitch4JGlobal.userAgent).withTimeout(timeout2 != null ? timeout2.intValue() : 5000).withRequestQueueSize(requestQueueSize != null ? requestQueueSize : -1).withLogLevel(logLevel != null ? logLevel : Logger.Level.NONE).withProxyConfig(proxyConfig).build();
    }

    @Override
    public HystrixCommand<ExtensionSecretList> createExtensionSecret(String clientId, String jsonWebToken, int activationDelaySeconds) {
        return new HystrixCommandConverter<ExtensionSecretsList, ExtensionSecretList>(this.helix.createExtensionSecret(jsonWebToken, this.getClientId(clientId), activationDelaySeconds), ExtensionsTypeConverters.SECRETS_CONVERTER);
    }

    @Override
    public HystrixCommand<ExtensionSecretList> getExtensionSecret(String clientId, String jsonWebToken) {
        return new HystrixCommandConverter<ExtensionSecretsList, ExtensionSecretList>(this.helix.getExtensionSecrets(jsonWebToken, this.getClientId(clientId)), ExtensionsTypeConverters.SECRETS_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> revokeExtensionSecrets(String clientId, String jsonWebToken) {
        throw new UnsupportedOperationException("There is no direct Helix replacement for this endpoint.");
    }

    @Override
    public HystrixCommand<ChannelList> getLiveChannelsWithExtensionActivated(String clientId, String cursor) {
        return new HystrixCommandConverter<ExtensionLiveChannelsList, ChannelList>(this.helix.getExtensionLiveChannels(null, this.getClientId(clientId), 100, cursor), ExtensionsTypeConverters.LIVE_CHANNELS_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> setExtensionRequiredConfiguration(String clientId, String jsonWebToken, String extensionVersion, String channelId, String requiredConfiguration) {
        return this.helix.setExtensionRequiredConfiguration(jsonWebToken, this.getClientId(clientId), extensionVersion, requiredConfiguration, channelId);
    }

    @Override
    public HystrixCommand<Void> setExtensionConfigurationSegment(String clientId, String jsonWebToken, ExtensionConfigurationSegment configurationSegment) {
        String extensionId = this.getClientId(clientId);
        return this.helix.setExtensionConfigurationSegment(jsonWebToken, extensionId, ExtensionConfigurationSegmentInput.builder().extensionId(extensionId).segment(ExtensionsTypeConverters.SEGMENT_CONVERTER.apply(configurationSegment.getSegment())).broadcasterId(configurationSegment.getChannelId()).content(configurationSegment.getContent()).version(configurationSegment.getVersion()).build());
    }

    @Override
    public HystrixCommand<Map<String, ConfigurationSegment>> getExtensionChannelConfiguration(String clientId, String jsonWebToken, String channelId) {
        return new HystrixCommandConverter<ExtensionConfigurationSegmentList, Map<String, ConfigurationSegment>>(this.helix.getExtensionConfigurationSegment(jsonWebToken, this.getClientId(clientId), Arrays.asList(ExtensionSegment.BROADCASTER, ExtensionSegment.DEVELOPER), channelId), ExtensionsTypeConverters.CONFIG_SEGMENT_LIST_CONVERTER);
    }

    @Override
    public HystrixCommand<Map<String, ConfigurationSegment>> getExtensionConfigurationSegment(String clientId, String jsonWebToken, ConfigurationSegmentType segmentType, String channelId) {
        return new HystrixCommandConverter<ExtensionConfigurationSegmentList, Map<String, ConfigurationSegment>>(this.helix.getExtensionConfigurationSegment(jsonWebToken, this.getClientId(clientId), Collections.singletonList(ExtensionsTypeConverters.SEGMENT_CONVERTER.apply(segmentType)), channelId), ExtensionsTypeConverters.CONFIG_SEGMENT_LIST_CONVERTER);
    }

    @Override
    public HystrixCommand<Void> sendExtensionPubSubMessage(String clientId, String jsonWebToken, String channelId, String message, String targets) {
        return this.helix.sendExtensionPubSubMessage(jsonWebToken, this.getClientId(clientId), SendPubSubMessageInput.builder().broadcasterId(channelId).message(message).target(targets).globalBroadcast("global".equals(targets)).build());
    }

    @Override
    public HystrixCommand<Void> sendExtensionChatMessage(String clientId, String jsonWebToken, String extensionVersion, String channelId, String text) {
        return this.helix.sendExtensionChatMessage(jsonWebToken, this.getClientId(clientId), extensionVersion, channelId, text);
    }

    @Override
    public HystrixCommand<ExtensionInformation> getExtensionInformation(String clientId) {
        return new HystrixCommandConverter<ReleasedExtensionList, ExtensionInformation>(this.helix.getReleasedExtensions(null, this.getClientId(clientId), null), ExtensionsTypeConverters.EXTENSION_LIST_CONVERTER);
    }

    private String getClientId(String overrideId) {
        return StringUtils.isNotBlank(overrideId) ? overrideId : this.clientId;
    }

    @Generated
    public static TwitchExtensionsCompatibilityLayerBuilder builder() {
        return new TwitchExtensionsCompatibilityLayerBuilder();
    }

    @Generated
    public static class TwitchExtensionsCompatibilityLayerBuilder {
        @Generated
        private String clientId;
        @Generated
        private String clientSecret;
        @Generated
        private String userAgent;
        @Generated
        private Long timeout;
        @Generated
        private Integer requestQueueSize;
        @Generated
        private Logger.Level logLevel;
        @Generated
        private ProxyConfig proxyConfig;

        @Generated
        TwitchExtensionsCompatibilityLayerBuilder() {
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder clientSecret(String clientSecret) {
            this.clientSecret = clientSecret;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder userAgent(String userAgent) {
            this.userAgent = userAgent;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder timeout(Long timeout2) {
            this.timeout = timeout2;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder requestQueueSize(Integer requestQueueSize) {
            this.requestQueueSize = requestQueueSize;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder logLevel(Logger.Level logLevel) {
            this.logLevel = logLevel;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayerBuilder proxyConfig(ProxyConfig proxyConfig) {
            this.proxyConfig = proxyConfig;
            return this;
        }

        @Generated
        public TwitchExtensionsCompatibilityLayer build() {
            return new TwitchExtensionsCompatibilityLayer(this.clientId, this.clientSecret, this.userAgent, this.timeout, this.requestQueueSize, this.logLevel, this.proxyConfig);
        }

        @Generated
        public String toString() {
            return "TwitchExtensionsCompatibilityLayer.TwitchExtensionsCompatibilityLayerBuilder(clientId=" + this.clientId + ", clientSecret=" + this.clientSecret + ", userAgent=" + this.userAgent + ", timeout=" + this.timeout + ", requestQueueSize=" + this.requestQueueSize + ", logLevel=" + (Object)((Object)this.logLevel) + ", proxyConfig=" + this.proxyConfig + ")";
        }
    }
}

