/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.extensions.util;

import com.morelaid.streamingmodule.external.twitch4j.extensions.TwitchExtensionsBuilder;
import feign.RequestInterceptor;
import feign.RequestTemplate;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

public class TwitchExtensionsClientIdInterceptor
implements RequestInterceptor {
    private static final String HEADER_NAME = "Client-Id";
    private final String defaultClientId;
    private final String userAgent;

    public TwitchExtensionsClientIdInterceptor(TwitchExtensionsBuilder builder) {
        this.defaultClientId = builder.getClientId();
        this.userAgent = builder.getUserAgent();
    }

    @Override
    public void apply(RequestTemplate template) {
        String url;
        Collection<String> headers = template.headers().get(HEADER_NAME);
        if (headers == null || headers.size() != 1 || StringUtils.isBlank(headers.iterator().next())) {
            template.removeHeader(HEADER_NAME);
            template.header(HEADER_NAME, this.defaultClientId);
        }
        template.uri((url = template.url()).startsWith("//") ? '/' + this.defaultClientId + '/' + url.substring(2) : url);
        template.header("User-Agent", this.userAgent);
    }
}

