/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonInclude;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonDeserialize;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonPOJOBuilder;
import java.util.Arrays;
import java.util.Objects;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=AutoModSettingsBuilder.class)
public class AutoModSettings {
    private String broadcasterId;
    private String moderatorId;
    @Nullable
    private Integer overallLevel;
    private Integer aggression;
    private Integer bullying;
    private Integer disability;
    private Integer misogyny;
    private Integer raceEthnicityOrReligion;
    private Integer sexBasedTerms;
    private Integer sexualitySexOrGender;
    private Integer swearing;

    public boolean isValidConfiguration() {
        Integer[] levels = new Integer[]{this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing};
        boolean individual = Arrays.stream(levels).anyMatch(Objects::nonNull);
        if (individual) {
            if (this.overallLevel != null) {
                return false;
            }
            for (Integer level : levels) {
                if (level == null || level >= 0 && level <= 4) continue;
                return false;
            }
        }
        return true;
    }

    @Generated
    public static AutoModSettingsBuilder builder() {
        return new AutoModSettingsBuilder();
    }

    @Generated
    public AutoModSettingsBuilder toBuilder() {
        return new AutoModSettingsBuilder().broadcasterId(this.broadcasterId).moderatorId(this.moderatorId).overallLevel(this.overallLevel).aggression(this.aggression).bullying(this.bullying).disability(this.disability).misogyny(this.misogyny).raceEthnicityOrReligion(this.raceEthnicityOrReligion).sexBasedTerms(this.sexBasedTerms).sexualitySexOrGender(this.sexualitySexOrGender).swearing(this.swearing);
    }

    @Generated
    public AutoModSettings withBroadcasterId(String broadcasterId) {
        return this.broadcasterId == broadcasterId ? this : new AutoModSettings(broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withModeratorId(String moderatorId) {
        return this.moderatorId == moderatorId ? this : new AutoModSettings(this.broadcasterId, moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withOverallLevel(@Nullable Integer overallLevel) {
        return this.overallLevel == overallLevel ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withAggression(Integer aggression) {
        return this.aggression == aggression ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withBullying(Integer bullying) {
        return this.bullying == bullying ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withDisability(Integer disability) {
        return this.disability == disability ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withMisogyny(Integer misogyny) {
        return this.misogyny == misogyny ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withRaceEthnicityOrReligion(Integer raceEthnicityOrReligion) {
        return this.raceEthnicityOrReligion == raceEthnicityOrReligion ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withSexBasedTerms(Integer sexBasedTerms) {
        return this.sexBasedTerms == sexBasedTerms ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, sexBasedTerms, this.sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withSexualitySexOrGender(Integer sexualitySexOrGender) {
        return this.sexualitySexOrGender == sexualitySexOrGender ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, sexualitySexOrGender, this.swearing);
    }

    @Generated
    public AutoModSettings withSwearing(Integer swearing) {
        return this.swearing == swearing ? this : new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, swearing);
    }

    @Generated
    public String getBroadcasterId() {
        return this.broadcasterId;
    }

    @Generated
    public String getModeratorId() {
        return this.moderatorId;
    }

    @Nullable
    @Generated
    public Integer getOverallLevel() {
        return this.overallLevel;
    }

    @Generated
    public Integer getAggression() {
        return this.aggression;
    }

    @Generated
    public Integer getBullying() {
        return this.bullying;
    }

    @Generated
    public Integer getDisability() {
        return this.disability;
    }

    @Generated
    public Integer getMisogyny() {
        return this.misogyny;
    }

    @Generated
    public Integer getRaceEthnicityOrReligion() {
        return this.raceEthnicityOrReligion;
    }

    @Generated
    public Integer getSexBasedTerms() {
        return this.sexBasedTerms;
    }

    @Generated
    public Integer getSexualitySexOrGender() {
        return this.sexualitySexOrGender;
    }

    @Generated
    public Integer getSwearing() {
        return this.swearing;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoModSettings)) {
            return false;
        }
        AutoModSettings other = (AutoModSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$overallLevel = this.getOverallLevel();
        Integer other$overallLevel = other.getOverallLevel();
        if (this$overallLevel == null ? other$overallLevel != null : !((Object)this$overallLevel).equals(other$overallLevel)) {
            return false;
        }
        Integer this$aggression = this.getAggression();
        Integer other$aggression = other.getAggression();
        if (this$aggression == null ? other$aggression != null : !((Object)this$aggression).equals(other$aggression)) {
            return false;
        }
        Integer this$bullying = this.getBullying();
        Integer other$bullying = other.getBullying();
        if (this$bullying == null ? other$bullying != null : !((Object)this$bullying).equals(other$bullying)) {
            return false;
        }
        Integer this$disability = this.getDisability();
        Integer other$disability = other.getDisability();
        if (this$disability == null ? other$disability != null : !((Object)this$disability).equals(other$disability)) {
            return false;
        }
        Integer this$misogyny = this.getMisogyny();
        Integer other$misogyny = other.getMisogyny();
        if (this$misogyny == null ? other$misogyny != null : !((Object)this$misogyny).equals(other$misogyny)) {
            return false;
        }
        Integer this$raceEthnicityOrReligion = this.getRaceEthnicityOrReligion();
        Integer other$raceEthnicityOrReligion = other.getRaceEthnicityOrReligion();
        if (this$raceEthnicityOrReligion == null ? other$raceEthnicityOrReligion != null : !((Object)this$raceEthnicityOrReligion).equals(other$raceEthnicityOrReligion)) {
            return false;
        }
        Integer this$sexBasedTerms = this.getSexBasedTerms();
        Integer other$sexBasedTerms = other.getSexBasedTerms();
        if (this$sexBasedTerms == null ? other$sexBasedTerms != null : !((Object)this$sexBasedTerms).equals(other$sexBasedTerms)) {
            return false;
        }
        Integer this$sexualitySexOrGender = this.getSexualitySexOrGender();
        Integer other$sexualitySexOrGender = other.getSexualitySexOrGender();
        if (this$sexualitySexOrGender == null ? other$sexualitySexOrGender != null : !((Object)this$sexualitySexOrGender).equals(other$sexualitySexOrGender)) {
            return false;
        }
        Integer this$swearing = this.getSwearing();
        Integer other$swearing = other.getSwearing();
        if (this$swearing == null ? other$swearing != null : !((Object)this$swearing).equals(other$swearing)) {
            return false;
        }
        String this$broadcasterId = this.getBroadcasterId();
        String other$broadcasterId = other.getBroadcasterId();
        if (this$broadcasterId == null ? other$broadcasterId != null : !this$broadcasterId.equals(other$broadcasterId)) {
            return false;
        }
        String this$moderatorId = this.getModeratorId();
        String other$moderatorId = other.getModeratorId();
        return !(this$moderatorId == null ? other$moderatorId != null : !this$moderatorId.equals(other$moderatorId));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AutoModSettings;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $overallLevel = this.getOverallLevel();
        result = result * 59 + ($overallLevel == null ? 43 : ((Object)$overallLevel).hashCode());
        Integer $aggression = this.getAggression();
        result = result * 59 + ($aggression == null ? 43 : ((Object)$aggression).hashCode());
        Integer $bullying = this.getBullying();
        result = result * 59 + ($bullying == null ? 43 : ((Object)$bullying).hashCode());
        Integer $disability = this.getDisability();
        result = result * 59 + ($disability == null ? 43 : ((Object)$disability).hashCode());
        Integer $misogyny = this.getMisogyny();
        result = result * 59 + ($misogyny == null ? 43 : ((Object)$misogyny).hashCode());
        Integer $raceEthnicityOrReligion = this.getRaceEthnicityOrReligion();
        result = result * 59 + ($raceEthnicityOrReligion == null ? 43 : ((Object)$raceEthnicityOrReligion).hashCode());
        Integer $sexBasedTerms = this.getSexBasedTerms();
        result = result * 59 + ($sexBasedTerms == null ? 43 : ((Object)$sexBasedTerms).hashCode());
        Integer $sexualitySexOrGender = this.getSexualitySexOrGender();
        result = result * 59 + ($sexualitySexOrGender == null ? 43 : ((Object)$sexualitySexOrGender).hashCode());
        Integer $swearing = this.getSwearing();
        result = result * 59 + ($swearing == null ? 43 : ((Object)$swearing).hashCode());
        String $broadcasterId = this.getBroadcasterId();
        result = result * 59 + ($broadcasterId == null ? 43 : $broadcasterId.hashCode());
        String $moderatorId = this.getModeratorId();
        result = result * 59 + ($moderatorId == null ? 43 : $moderatorId.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AutoModSettings(broadcasterId=" + this.getBroadcasterId() + ", moderatorId=" + this.getModeratorId() + ", overallLevel=" + this.getOverallLevel() + ", aggression=" + this.getAggression() + ", bullying=" + this.getBullying() + ", disability=" + this.getDisability() + ", misogyny=" + this.getMisogyny() + ", raceEthnicityOrReligion=" + this.getRaceEthnicityOrReligion() + ", sexBasedTerms=" + this.getSexBasedTerms() + ", sexualitySexOrGender=" + this.getSexualitySexOrGender() + ", swearing=" + this.getSwearing() + ")";
    }

    @Generated
    private void setBroadcasterId(String broadcasterId) {
        this.broadcasterId = broadcasterId;
    }

    @Generated
    private void setModeratorId(String moderatorId) {
        this.moderatorId = moderatorId;
    }

    @Generated
    private void setOverallLevel(@Nullable Integer overallLevel) {
        this.overallLevel = overallLevel;
    }

    @Generated
    private void setAggression(Integer aggression) {
        this.aggression = aggression;
    }

    @Generated
    private void setBullying(Integer bullying) {
        this.bullying = bullying;
    }

    @Generated
    private void setDisability(Integer disability) {
        this.disability = disability;
    }

    @Generated
    private void setMisogyny(Integer misogyny) {
        this.misogyny = misogyny;
    }

    @Generated
    private void setRaceEthnicityOrReligion(Integer raceEthnicityOrReligion) {
        this.raceEthnicityOrReligion = raceEthnicityOrReligion;
    }

    @Generated
    private void setSexBasedTerms(Integer sexBasedTerms) {
        this.sexBasedTerms = sexBasedTerms;
    }

    @Generated
    private void setSexualitySexOrGender(Integer sexualitySexOrGender) {
        this.sexualitySexOrGender = sexualitySexOrGender;
    }

    @Generated
    private void setSwearing(Integer swearing) {
        this.swearing = swearing;
    }

    @Generated
    public AutoModSettings() {
    }

    @Generated
    public AutoModSettings(String broadcasterId, String moderatorId, @Nullable Integer overallLevel, Integer aggression, Integer bullying, Integer disability, Integer misogyny, Integer raceEthnicityOrReligion, Integer sexBasedTerms, Integer sexualitySexOrGender, Integer swearing) {
        this.broadcasterId = broadcasterId;
        this.moderatorId = moderatorId;
        this.overallLevel = overallLevel;
        this.aggression = aggression;
        this.bullying = bullying;
        this.disability = disability;
        this.misogyny = misogyny;
        this.raceEthnicityOrReligion = raceEthnicityOrReligion;
        this.sexBasedTerms = sexBasedTerms;
        this.sexualitySexOrGender = sexualitySexOrGender;
        this.swearing = swearing;
    }

    @JsonPOJOBuilder(withPrefix="", buildMethodName="build")
    @Generated
    public static class AutoModSettingsBuilder {
        @Generated
        private String broadcasterId;
        @Generated
        private String moderatorId;
        @Generated
        private Integer overallLevel;
        @Generated
        private Integer aggression;
        @Generated
        private Integer bullying;
        @Generated
        private Integer disability;
        @Generated
        private Integer misogyny;
        @Generated
        private Integer raceEthnicityOrReligion;
        @Generated
        private Integer sexBasedTerms;
        @Generated
        private Integer sexualitySexOrGender;
        @Generated
        private Integer swearing;

        @Generated
        AutoModSettingsBuilder() {
        }

        @Generated
        public AutoModSettingsBuilder broadcasterId(String broadcasterId) {
            this.broadcasterId = broadcasterId;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder moderatorId(String moderatorId) {
            this.moderatorId = moderatorId;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder overallLevel(@Nullable Integer overallLevel) {
            this.overallLevel = overallLevel;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder aggression(Integer aggression) {
            this.aggression = aggression;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder bullying(Integer bullying) {
            this.bullying = bullying;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder disability(Integer disability) {
            this.disability = disability;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder misogyny(Integer misogyny) {
            this.misogyny = misogyny;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder raceEthnicityOrReligion(Integer raceEthnicityOrReligion) {
            this.raceEthnicityOrReligion = raceEthnicityOrReligion;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder sexBasedTerms(Integer sexBasedTerms) {
            this.sexBasedTerms = sexBasedTerms;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder sexualitySexOrGender(Integer sexualitySexOrGender) {
            this.sexualitySexOrGender = sexualitySexOrGender;
            return this;
        }

        @Generated
        public AutoModSettingsBuilder swearing(Integer swearing) {
            this.swearing = swearing;
            return this;
        }

        @Generated
        public AutoModSettings build() {
            return new AutoModSettings(this.broadcasterId, this.moderatorId, this.overallLevel, this.aggression, this.bullying, this.disability, this.misogyny, this.raceEthnicityOrReligion, this.sexBasedTerms, this.sexualitySexOrGender, this.swearing);
        }

        @Generated
        public String toString() {
            return "AutoModSettings.AutoModSettingsBuilder(broadcasterId=" + this.broadcasterId + ", moderatorId=" + this.moderatorId + ", overallLevel=" + this.overallLevel + ", aggression=" + this.aggression + ", bullying=" + this.bullying + ", disability=" + this.disability + ", misogyny=" + this.misogyny + ", raceEthnicityOrReligion=" + this.raceEthnicityOrReligion + ", sexBasedTerms=" + this.sexBasedTerms + ", sexualitySexOrGender=" + this.sexualitySexOrGender + ", swearing=" + this.swearing + ")";
        }
    }
}

