/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonIgnore;
import com.morelaid.streamingmodule.external.jackson.annotation.JsonProperty;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TimeUtils;
import java.time.Duration;
import java.time.Instant;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import lombok.Generated;
import lombok.NonNull;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class Stream {
    @NonNull
    private String id;
    @NonNull
    private String userId;
    @NonNull
    private String userLogin;
    @NonNull
    private String userName;
    private String gameId;
    private String gameName;
    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    private List<UUID> communityIds;
    @NonNull
    private String type;
    @NonNull
    private String title;
    private List<String> tags;
    @NonNull
    private Integer viewerCount;
    @JsonProperty(value="started_at")
    @NonNull
    private Instant startedAtInstant;
    @Deprecated
    @Nullable
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    private List<UUID> tagIds;
    @JsonProperty(value="is_mature")
    private Boolean isMature;
    @NonNull
    private String language;
    @JsonProperty(value="thumbnail_url")
    @NonNull
    private String thumbnailUrlTemplate;

    public Duration getUptime() {
        return Duration.between(this.startedAtInstant, Instant.now());
    }

    public String getThumbnailUrl(int width, int height) {
        return this.thumbnailUrlTemplate.replace("{width}x{height}", String.format("%dx%d", width, height));
    }

    @JsonIgnore
    @Deprecated
    @NonNull
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public String getThumbnailUrl() {
        return this.thumbnailUrlTemplate;
    }

    @JsonIgnore
    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
    public Calendar getStartedAt() {
        return TimeUtils.fromInstant(this.startedAtInstant);
    }

    @NonNull
    @Generated
    public String getId() {
        return this.id;
    }

    @NonNull
    @Generated
    public String getUserId() {
        return this.userId;
    }

    @NonNull
    @Generated
    public String getUserLogin() {
        return this.userLogin;
    }

    @NonNull
    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getGameId() {
        return this.gameId;
    }

    @Generated
    public String getGameName() {
        return this.gameName;
    }

    @Deprecated
    @Nullable
    @Generated
    public List<UUID> getCommunityIds() {
        return this.communityIds;
    }

    @NonNull
    @Generated
    public String getType() {
        return this.type;
    }

    @NonNull
    @Generated
    public String getTitle() {
        return this.title;
    }

    @Generated
    public List<String> getTags() {
        return this.tags;
    }

    @NonNull
    @Generated
    public Integer getViewerCount() {
        return this.viewerCount;
    }

    @NonNull
    @Generated
    public Instant getStartedAtInstant() {
        return this.startedAtInstant;
    }

    @Deprecated
    @Nullable
    @Generated
    public List<UUID> getTagIds() {
        return this.tagIds;
    }

    @Generated
    public Boolean isMature() {
        return this.isMature;
    }

    @NonNull
    @Generated
    public String getLanguage() {
        return this.language;
    }

    @NonNull
    @Generated
    public String getThumbnailUrlTemplate() {
        return this.thumbnailUrlTemplate;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Stream)) {
            return false;
        }
        Stream other = (Stream)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$viewerCount = this.getViewerCount();
        Integer other$viewerCount = other.getViewerCount();
        if (this$viewerCount == null ? other$viewerCount != null : !((Object)this$viewerCount).equals(other$viewerCount)) {
            return false;
        }
        Boolean this$isMature = this.isMature();
        Boolean other$isMature = other.isMature();
        if (this$isMature == null ? other$isMature != null : !((Object)this$isMature).equals(other$isMature)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$userLogin = this.getUserLogin();
        String other$userLogin = other.getUserLogin();
        if (this$userLogin == null ? other$userLogin != null : !this$userLogin.equals(other$userLogin)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$gameId = this.getGameId();
        String other$gameId = other.getGameId();
        if (this$gameId == null ? other$gameId != null : !this$gameId.equals(other$gameId)) {
            return false;
        }
        String this$gameName = this.getGameName();
        String other$gameName = other.getGameName();
        if (this$gameName == null ? other$gameName != null : !this$gameName.equals(other$gameName)) {
            return false;
        }
        List<UUID> this$communityIds = this.getCommunityIds();
        List<UUID> other$communityIds = other.getCommunityIds();
        if (this$communityIds == null ? other$communityIds != null : !((Object)this$communityIds).equals(other$communityIds)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<String> this$tags = this.getTags();
        List<String> other$tags = other.getTags();
        if (this$tags == null ? other$tags != null : !((Object)this$tags).equals(other$tags)) {
            return false;
        }
        Instant this$startedAtInstant = this.getStartedAtInstant();
        Instant other$startedAtInstant = other.getStartedAtInstant();
        if (this$startedAtInstant == null ? other$startedAtInstant != null : !((Object)this$startedAtInstant).equals(other$startedAtInstant)) {
            return false;
        }
        List<UUID> this$tagIds = this.getTagIds();
        List<UUID> other$tagIds = other.getTagIds();
        if (this$tagIds == null ? other$tagIds != null : !((Object)this$tagIds).equals(other$tagIds)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        if (this$language == null ? other$language != null : !this$language.equals(other$language)) {
            return false;
        }
        String this$thumbnailUrlTemplate = this.getThumbnailUrlTemplate();
        String other$thumbnailUrlTemplate = other.getThumbnailUrlTemplate();
        return !(this$thumbnailUrlTemplate == null ? other$thumbnailUrlTemplate != null : !this$thumbnailUrlTemplate.equals(other$thumbnailUrlTemplate));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Stream;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $viewerCount = this.getViewerCount();
        result = result * 59 + ($viewerCount == null ? 43 : ((Object)$viewerCount).hashCode());
        Boolean $isMature = this.isMature();
        result = result * 59 + ($isMature == null ? 43 : ((Object)$isMature).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $userLogin = this.getUserLogin();
        result = result * 59 + ($userLogin == null ? 43 : $userLogin.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $gameId = this.getGameId();
        result = result * 59 + ($gameId == null ? 43 : $gameId.hashCode());
        String $gameName = this.getGameName();
        result = result * 59 + ($gameName == null ? 43 : $gameName.hashCode());
        List<UUID> $communityIds = this.getCommunityIds();
        result = result * 59 + ($communityIds == null ? 43 : ((Object)$communityIds).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<String> $tags = this.getTags();
        result = result * 59 + ($tags == null ? 43 : ((Object)$tags).hashCode());
        Instant $startedAtInstant = this.getStartedAtInstant();
        result = result * 59 + ($startedAtInstant == null ? 43 : ((Object)$startedAtInstant).hashCode());
        List<UUID> $tagIds = this.getTagIds();
        result = result * 59 + ($tagIds == null ? 43 : ((Object)$tagIds).hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        String $thumbnailUrlTemplate = this.getThumbnailUrlTemplate();
        result = result * 59 + ($thumbnailUrlTemplate == null ? 43 : $thumbnailUrlTemplate.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Stream(id=" + this.getId() + ", userId=" + this.getUserId() + ", userLogin=" + this.getUserLogin() + ", userName=" + this.getUserName() + ", gameId=" + this.getGameId() + ", gameName=" + this.getGameName() + ", communityIds=" + this.getCommunityIds() + ", type=" + this.getType() + ", title=" + this.getTitle() + ", tags=" + this.getTags() + ", viewerCount=" + this.getViewerCount() + ", startedAtInstant=" + this.getStartedAtInstant() + ", tagIds=" + this.getTagIds() + ", isMature=" + this.isMature() + ", language=" + this.getLanguage() + ", thumbnailUrlTemplate=" + this.getThumbnailUrlTemplate() + ")";
    }

    @Generated
    private void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @Generated
    private void setUserId(@NonNull String userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @Generated
    private void setUserLogin(@NonNull String userLogin) {
        if (userLogin == null) {
            throw new NullPointerException("userLogin is marked non-null but is null");
        }
        this.userLogin = userLogin;
    }

    @Generated
    private void setUserName(@NonNull String userName) {
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        this.userName = userName;
    }

    @Generated
    private void setGameId(String gameId) {
        this.gameId = gameId;
    }

    @Generated
    private void setGameName(String gameName) {
        this.gameName = gameName;
    }

    @Deprecated
    @Generated
    private void setCommunityIds(@Nullable List<UUID> communityIds) {
        this.communityIds = communityIds;
    }

    @Generated
    private void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @Generated
    private void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @Generated
    private void setTags(List<String> tags) {
        this.tags = tags;
    }

    @Generated
    private void setViewerCount(@NonNull Integer viewerCount) {
        if (viewerCount == null) {
            throw new NullPointerException("viewerCount is marked non-null but is null");
        }
        this.viewerCount = viewerCount;
    }

    @JsonProperty(value="started_at")
    @Generated
    private void setStartedAtInstant(@NonNull Instant startedAtInstant) {
        if (startedAtInstant == null) {
            throw new NullPointerException("startedAtInstant is marked non-null but is null");
        }
        this.startedAtInstant = startedAtInstant;
    }

    @Deprecated
    @Generated
    private void setTagIds(@Nullable List<UUID> tagIds) {
        this.tagIds = tagIds;
    }

    @JsonProperty(value="is_mature")
    @Generated
    private Stream isMature(Boolean isMature) {
        this.isMature = isMature;
        return this;
    }

    @Generated
    private void setLanguage(@NonNull String language) {
        if (language == null) {
            throw new NullPointerException("language is marked non-null but is null");
        }
        this.language = language;
    }

    @JsonProperty(value="thumbnail_url")
    @Generated
    private void setThumbnailUrlTemplate(@NonNull String thumbnailUrlTemplate) {
        if (thumbnailUrlTemplate == null) {
            throw new NullPointerException("thumbnailUrlTemplate is marked non-null but is null");
        }
        this.thumbnailUrlTemplate = thumbnailUrlTemplate;
    }

    @Generated
    public Stream() {
    }
}

