/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.interceptor;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixHttpClient;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import feign.Request;
import feign.Response;
import feign.jackson.JacksonDecoder;
import java.io.IOException;
import java.lang.reflect.Type;

public class TwitchHelixDecoder
extends JacksonDecoder {
    public static final String REMAINING_HEADER = "Ratelimit-Remaining";
    private final TwitchHelixRateLimitTracker rateLimitTracker;

    public TwitchHelixDecoder(ObjectMapper mapper, TwitchHelixRateLimitTracker rateLimitTracker) {
        super(mapper);
        this.rateLimitTracker = rateLimitTracker;
    }

    @Override
    public Object decode(Response response, Type type) throws IOException {
        Request request = response.request();
        String token = TwitchHelixHttpClient.getFirstHeader("Authorization", request);
        if (token != null && token.startsWith("Bearer ")) {
            Integer remaining;
            String remainingStr = TwitchHelixHttpClient.getFirst(REMAINING_HEADER, response.headers());
            try {
                remaining = Integer.parseInt(remainingStr);
            }
            catch (NumberFormatException ignored) {
                remaining = null;
            }
            if (remaining != null) {
                String bearer = token.substring("Bearer ".length());
                if (request.httpMethod() == Request.HttpMethod.POST && request.requestTemplate().path().endsWith("/clips")) {
                    this.rateLimitTracker.updateRemainingCreateClip(bearer, remaining);
                } else if (request.httpMethod() == Request.HttpMethod.POST && request.requestTemplate().path().endsWith("/extensions/chat")) {
                    String clientId = TwitchHelixHttpClient.getFirstHeader("Client-Id", request);
                    String channelId = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
                    this.rateLimitTracker.updateRemainingExtensionChat(clientId, channelId, remaining);
                } else if (request.httpMethod() == Request.HttpMethod.POST && request.requestTemplate().path().endsWith("/extensions/pubsub")) {
                    String clientId = TwitchHelixHttpClient.getFirstHeader("Client-Id", request);
                    String target = TwitchHelixHttpClient.getFirstHeader("Twitch4J-Target", request);
                    this.rateLimitTracker.updateRemainingExtensionPubSub(clientId, target, remaining);
                } else {
                    this.rateLimitTracker.updateRemaining(bearer, remaining);
                }
            }
        }
        return super.decode(response, type);
    }
}

