/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.helix.interceptor;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.morelaid.streamingmodule.external.twitch4j.common.util.BucketUtils;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixRateLimitTracker;
import com.morelaid.streamingmodule.external.twitch4j.helix.interceptor.TwitchHelixTokenManager;
import feign.Client;
import feign.Request;
import feign.Response;
import feign.okhttp.OkHttpClient;
import io.github.bucket4j.Bucket;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TwitchHelixHttpClient
implements Client {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchHelixHttpClient.class);
    private final Client client;
    private final ScheduledExecutorService executor;
    private final TwitchHelixTokenManager tokenManager;
    private final TwitchHelixRateLimitTracker rateLimitTracker;
    private final long timeout;

    public TwitchHelixHttpClient(OkHttpClient client, ScheduledThreadPoolExecutor executor, TwitchHelixTokenManager tokenManager, TwitchHelixRateLimitTracker rateLimitTracker, Integer timeout2) {
        this.client = client;
        this.executor = executor;
        this.tokenManager = tokenManager;
        this.rateLimitTracker = rateLimitTracker;
        this.timeout = timeout2 == null ? 60000L : timeout2.longValue();
    }

    @Override
    public Response execute(Request request, Request.Options options) throws IOException {
        OAuth2Credential credential;
        String token = TwitchHelixHttpClient.getFirstHeader("Authorization", request);
        if (token != null && token.startsWith("Bearer ") && (credential = this.tokenManager.getIfPresent(token.substring("Bearer ".length()))) != null) {
            Bucket bucket = this.rateLimitTracker.getOrInitializeBucket(this.rateLimitTracker.getPrimaryBucketKey(credential));
            return this.executeAgainstBucket(bucket, () -> this.delegatedExecute(request, options));
        }
        return this.delegatedExecute(request, options);
    }

    private Response delegatedExecute(Request request, Request.Options options) throws IOException {
        String channelId;
        String clientId;
        String channelId2;
        String templatePath = request.requestTemplate().path();
        if (templatePath.endsWith("/channels/vips")) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket vipBucket = request.httpMethod() == Request.HttpMethod.POST ? this.rateLimitTracker.getVipAddBucket(channelId2) : (request.httpMethod() == Request.HttpMethod.DELETE ? this.rateLimitTracker.getVipRemoveBucket(channelId2) : null);
            if (vipBucket != null) {
                return this.executeAgainstBucket(vipBucket, () -> this.client.execute(request, options));
            }
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/chat/announcements")) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket announceBucket = this.rateLimitTracker.getChatAnnouncementBucket(channelId2);
            return this.executeAgainstBucket(announceBucket, () -> this.client.execute(request, options));
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/moderation/enforcements/status")) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket autoModBucket = this.rateLimitTracker.getAutomodStatusBucket(channelId2);
            return this.executeAgainstBucket(autoModBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/moderation/bans")) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket modBucket = this.rateLimitTracker.getModerationBucket(channelId2);
            return this.executeAgainstBucket(modBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/moderation/blocked_terms") && (request.httpMethod() == Request.HttpMethod.POST || request.httpMethod() == Request.HttpMethod.DELETE)) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket termsBucket = this.rateLimitTracker.getTermsBucket(channelId2);
            return this.executeAgainstBucket(termsBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/moderation/moderators")) {
            channelId2 = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket modsBucket = request.httpMethod() == Request.HttpMethod.POST ? this.rateLimitTracker.getModAddBucket(channelId2) : (request.httpMethod() == Request.HttpMethod.DELETE ? this.rateLimitTracker.getModRemoveBucket(channelId2) : null);
            if (modsBucket != null) {
                return this.executeAgainstBucket(modsBucket, () -> this.client.execute(request, options));
            }
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/clips")) {
            String token = Objects.requireNonNull(TwitchHelixHttpClient.getFirstHeader("Authorization", request)).substring("Bearer ".length());
            OAuth2Credential cred = this.tokenManager.getIfPresent(token);
            String userId = cred != null ? cred.getUserId() : "";
            Bucket clipBucket = this.rateLimitTracker.getClipBucket(userId != null ? userId : "");
            return this.executeAgainstBucket(clipBucket, () -> this.client.execute(request, options));
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/extensions/chat")) {
            clientId = TwitchHelixHttpClient.getFirstHeader("Client-Id", request);
            channelId = TwitchHelixHttpClient.getFirstParam("broadcaster_id", request);
            Bucket chatBucket = this.rateLimitTracker.getExtensionChatBucket(Objects.requireNonNull(clientId), Objects.requireNonNull(channelId));
            return this.executeAgainstBucket(chatBucket, () -> this.client.execute(request, options));
        }
        if (request.httpMethod() == Request.HttpMethod.POST && templatePath.endsWith("/extensions/pubsub")) {
            clientId = TwitchHelixHttpClient.getFirstHeader("Client-Id", request);
            String target = TwitchHelixHttpClient.getFirstHeader("Twitch4J-Target", request);
            Bucket pubSubBucket = this.rateLimitTracker.getExtensionPubSubBucket(Objects.requireNonNull(clientId), Objects.requireNonNull(target));
            return this.executeAgainstBucket(pubSubBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/raids")) {
            String param = request.httpMethod() == Request.HttpMethod.POST ? "from_broadcaster_id" : "broadcaster_id";
            channelId = TwitchHelixHttpClient.getFirstParam(param, request);
            Bucket raidBucket = this.rateLimitTracker.getRaidsBucket(Objects.requireNonNull(channelId));
            return this.executeAgainstBucket(raidBucket, () -> this.client.execute(request, options));
        }
        if (templatePath.endsWith("/whispers")) {
            String userId = TwitchHelixHttpClient.getFirstParam("from_user_id", request);
            Bucket whisperBucket = this.rateLimitTracker.getWhispersBucket(Objects.requireNonNull(userId));
            return this.executeAgainstBucket(whisperBucket, () -> this.client.execute(request, options));
        }
        return this.client.execute(request, options);
    }

    @Nullable
    static String getFirstHeader(String key, Request request) {
        return TwitchHelixHttpClient.getFirst(key, request.headers());
    }

    @Nullable
    static String getFirstParam(String key, Request request) {
        return TwitchHelixHttpClient.getFirst(key, request.requestTemplate().queries());
    }

    @Nullable
    static String getFirst(String key, Map<String, Collection<String>> map) {
        Collection<String> values2 = map.get(key);
        return values2 != null && !values2.isEmpty() ? values2.iterator().next() : null;
    }

    private <T> T executeAgainstBucket(Bucket bucket, Callable<T> call) throws IOException {
        try {
            return BucketUtils.scheduleAgainstBucket(bucket, this.executor, call).get(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            log.error("Throttled Helix API call timed-out before completion", e);
            return null;
        }
    }
}

