/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.internal;

import com.github.philippheuer.credentialmanager.domain.OAuth2Credential;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ListModsEvent;
import com.morelaid.streamingmodule.external.twitch4j.chat.events.channel.ListVipsEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.enums.AnnouncementColor;
import com.morelaid.streamingmodule.external.twitch4j.common.events.domain.EventChannel;
import com.morelaid.streamingmodule.external.twitch4j.helix.TwitchHelix;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.BanUserInput;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ChannelVip;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ChannelVipList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ChatSettings;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.Highlight;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.Moderator;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.ModeratorList;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.NamedUserChatColor;
import com.morelaid.streamingmodule.external.twitch4j.helix.domain.User;
import com.morelaid.streamingmodule.external.twitch4j.internal.ChatCommandHandler;
import com.morelaid.streamingmodule.external.twitch4j.internal.ChatCommandHelixForwarder;
import com.morelaid.streamingmodule.external.twitch4j.internal.ChatCommandRateLimitType;
import com.morelaid.streamingmodule.external.twitch4j.util.EnumUtil;
import com.morelaid.streamingmodule.external.twitch4j.util.PaginationUtil;
import io.github.xanthic.cache.api.Cache;
import io.github.xanthic.cache.api.domain.ExpiryType;
import io.github.xanthic.cache.core.CacheApi;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

enum ChatCommandRegistry {
    INSTANCE;

    @Generated
    private static final Logger log;
    private static final Map<String, String> HELIX_COLORS_BY_LOWER_CHAT_NAME;
    private static final Cache<String, String> USER_ID_BY_LOGIN_CACHE;
    private final Map<String, ChatCommandHandler> commandHandlers;

    private ChatCommandRegistry() {
        HashMap<String, ChatCommandHandler> m4 = new HashMap<String, ChatCommandHandler>();
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, AnnouncementColor> announceHandler = (args2, color) -> {
            if (args2.getRestOfMessage() == null || args2.getRestOfMessage().isEmpty()) {
                return;
            }
            args2.getHelix().sendChatAnnouncement(args2.getToken().getAccessToken(), args2.getChannelId(), args2.getToken().getUserId(), args2.getRestOfMessage(), (AnnouncementColor)((Object)color)).execute();
        };
        m4.put("announce", args2 -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, AnnouncementColor.PRIMARY));
        m4.put("announceblue", args2 -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, AnnouncementColor.BLUE));
        m4.put("announcegreen", args2 -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, AnnouncementColor.GREEN));
        m4.put("announceorange", args2 -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, AnnouncementColor.ORANGE));
        m4.put("announcepurple", args2 -> announceHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, AnnouncementColor.PURPLE));
        m4.put("ban", args2 -> {
            String[] banParts = StringUtils.split(args2.getRestOfMessage(), " ", 2);
            if (banParts.length == 0) {
                return;
            }
            String banReason = banParts.length > 1 ? banParts[1] : "";
            ChatCommandRegistry.doBan(args2.getHelix(), args2.getToken(), args2.getChannelId(), ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), banParts[0], null), banReason, null);
        });
        m4.put("color", new ChatCommandHandler(){

            @Override
            public void accept(ChatCommandHelixForwarder.CommandArguments args2) {
                String color;
                String string = color = args2.getRestOfMessage().startsWith("#") ? args2.getRestOfMessage() : (String)HELIX_COLORS_BY_LOWER_CHAT_NAME.get(args2.getRestOfMessage().toLowerCase());
                if (color == null) {
                    return;
                }
                args2.getHelix().updateUserChatColor(args2.getToken().getAccessToken(), args2.getToken().getUserId(), color).execute();
            }

            @Override
            public ChatCommandRateLimitType getLimitKey() {
                return ChatCommandRateLimitType.USER;
            }
        });
        m4.put("commercial", args2 -> {
            if (args2.getRestOfMessage() == null || args2.getRestOfMessage().isEmpty()) {
                return;
            }
            int length = Integer.parseInt(args2.getRestOfMessage());
            length = length / 30 * 30;
            length = Math.max(Math.min(length, 180), 30);
            args2.getHelix().startCommercial(args2.getToken().getAccessToken(), args2.getChannelId(), length).execute();
        });
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, String> deleteHandler = (args2, messageId) -> {
            if (messageId != null && messageId.isEmpty()) {
                return;
            }
            args2.getHelix().deleteChatMessages(args2.getToken().getAccessToken(), args2.getChannelId(), args2.getToken().getUserId(), (String)messageId).execute();
        };
        m4.put("clear", args2 -> deleteHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, (String)null));
        m4.put("delete", args2 -> deleteHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, args2.getRestOfMessage()));
        ChatCommandHandler unbanHandler = args2 -> {
            String userId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), args2.getRestOfMessage(), null);
            args2.getHelix().unbanUser(args2.getToken().getAccessToken(), args2.getChannelId(), args2.getToken().getUserId(), userId).execute();
        };
        m4.put("unban", unbanHandler);
        m4.put("untimeout", unbanHandler);
        m4.put("marker", args2 -> {
            String description = args2.getRestOfMessage() != null ? args2.getRestOfMessage() : "";
            args2.getHelix().createStreamMarker(args2.getToken().getAccessToken(), new Highlight(args2.getChannelId(), description)).execute();
        });
        m4.put("mod", args2 -> {
            String targetName = args2.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args2.getHelix().addChannelModerator(args2.getToken().getAccessToken(), args2.getChannelId(), targetId).execute();
        });
        m4.put("unmod", args2 -> {
            String targetName = args2.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args2.getHelix().removeChannelModerator(args2.getToken().getAccessToken(), args2.getChannelId(), targetId).execute();
        });
        m4.put("mods", args2 -> {
            String channelId = args2.getChannelId();
            if (args2.getChannelName() == null || channelId == null) {
                return;
            }
            AtomicBoolean failure = new AtomicBoolean();
            List<Moderator> mods = PaginationUtil.getPaginated(cursor -> {
                try {
                    return args2.getHelix().getModerators(args2.getToken().getAccessToken(), channelId, null, (String)cursor, 100).execute();
                }
                catch (Exception e) {
                    failure.set(true);
                    this.getLogger().warn("Failed to query moderators from Helix chat command forwarder", e);
                    return null;
                }
            }, ModeratorList::getModerators, result -> result.getPagination() != null ? result.getPagination().getCursor() : null);
            if (failure.get()) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>(mods.size());
            mods.forEach(v -> names.add(v.getUserLogin()));
            EventChannel channel = new EventChannel(channelId, args2.getChannelName());
            ListModsEvent event = new ListModsEvent(channel, names);
            args2.getChat().getEventManager().publish(event);
        });
        m4.put("raid", args2 -> {
            String targetName = args2.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args2.getHelix().startRaid(args2.getToken().getAccessToken(), args2.getChannelId(), targetId).execute();
        });
        m4.put("unraid", args2 -> args2.getHelix().cancelRaid(args2.getToken().getAccessToken(), args2.getChannelId()).execute());
        BiConsumer<ChatCommandHelixForwarder.CommandArguments, ChatSettings> roomHandler = (args2, settings) -> {
            if (settings == null) {
                return;
            }
            args2.getHelix().updateChatSettings(args2.getToken().getAccessToken(), args2.getChannelId(), args2.getToken().getUserId(), (ChatSettings)settings).execute();
        };
        m4.put("emoteonly", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isEmoteOnlyMode(true).build()));
        m4.put("emoteonlyoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isEmoteOnlyMode(false).build()));
        m4.put("followers", args2 -> {
            Integer followTime = ChatCommandRegistry.parseDuration(args2.getRestOfMessage());
            followTime = followTime != null ? followTime : 0;
            followTime = Math.min(Math.max(followTime, 0), 129600);
            roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isFollowersOnlyMode(true).followerModeDuration(followTime).build());
        });
        m4.put("followersoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isFollowersOnlyMode(false).build()));
        m4.put("slow", args2 -> {
            Integer slowTime = ChatCommandRegistry.parseDuration(args2.getRestOfMessage());
            slowTime = slowTime != null ? slowTime : 30;
            slowTime = Math.min(Math.max(slowTime, 3), 120);
            roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isSlowMode(true).slowModeWaitTime(slowTime).build());
        });
        m4.put("slowoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isSlowMode(false).build()));
        m4.put("subscribers", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isSubscribersOnlyMode(true).build()));
        m4.put("subscribersoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isSubscribersOnlyMode(false).build()));
        m4.put("r9kbeta", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isUniqueChatMode(true).build()));
        m4.put("uniquechat", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isUniqueChatMode(true).build()));
        m4.put("r9kbetaoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isUniqueChatMode(false).build()));
        m4.put("uniquechatoff", args2 -> roomHandler.accept((ChatCommandHelixForwarder.CommandArguments)args2, ChatSettings.builder().isUniqueChatMode(false).build()));
        m4.put("timeout", args2 -> {
            String[] timeoutParts = StringUtils.split(args2.getRestOfMessage(), " ", 3);
            if (timeoutParts.length < 2) {
                return;
            }
            String timeoutReason = timeoutParts.length >= 3 ? timeoutParts[2] : "";
            Integer seconds = ChatCommandRegistry.parseDuration(timeoutParts[1]);
            if (seconds == null) {
                return;
            }
            seconds = Math.min(Math.max(seconds, 1), 1209600);
            ChatCommandRegistry.doBan(args2.getHelix(), args2.getToken(), args2.getChannelId(), ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), timeoutParts[0], null), timeoutReason, seconds);
        });
        m4.put("vip", args2 -> {
            String targetName = args2.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args2.getHelix().addChannelVip(args2.getToken().getAccessToken(), args2.getChannelId(), targetId).execute();
        });
        m4.put("unvip", args2 -> {
            String targetName = args2.getRestOfMessage();
            if (targetName == null || targetName.isEmpty()) {
                return;
            }
            String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
            args2.getHelix().removeChannelVip(args2.getToken().getAccessToken(), args2.getChannelId(), targetId).execute();
        });
        m4.put("vips", args2 -> {
            String channelId = args2.getChannelId();
            if (args2.getChannelName() == null || channelId == null) {
                return;
            }
            AtomicBoolean failure = new AtomicBoolean();
            List<ChannelVip> vips = PaginationUtil.getPaginated(cursor -> {
                try {
                    return args2.getHelix().getChannelVips(args2.getToken().getAccessToken(), channelId, null, 100, (String)cursor).execute();
                }
                catch (Exception e) {
                    failure.set(true);
                    this.getLogger().warn("Failed to query VIPs from Helix chat command forwarder", e);
                    return null;
                }
            }, ChannelVipList::getData, result -> result.getPagination() != null ? result.getPagination().getCursor() : null);
            if (failure.get()) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>(vips.size());
            vips.forEach(v -> names.add(v.getUserLogin()));
            EventChannel channel = new EventChannel(channelId, args2.getChannelName());
            ListVipsEvent event = new ListVipsEvent(channel, names);
            args2.getChat().getEventManager().publish(event);
        });
        m4.put("w", new ChatCommandHandler(){

            @Override
            public void accept(ChatCommandHelixForwarder.CommandArguments args2) {
                String[] whisperParts = StringUtils.split(args2.getRestOfMessage(), " ", 2);
                if (whisperParts.length != 2) {
                    return;
                }
                String message = whisperParts[1];
                if (message == null || message.isEmpty()) {
                    return;
                }
                String targetName = whisperParts[0];
                String targetId = ChatCommandRegistry.getId(args2.getHelix(), args2.getToken(), targetName, args2.getChat().getChannelNameToChannelId().get(targetName.toLowerCase()));
                args2.getHelix().sendWhisper(args2.getToken().getAccessToken(), args2.getToken().getUserId(), targetId, message).execute();
            }

            @Override
            public ChatCommandRateLimitType getLimitKey() {
                return ChatCommandRateLimitType.USER;
            }
        });
        this.commandHandlers = Collections.unmodifiableMap(m4);
    }

    private Logger getLogger() {
        return log;
    }

    static String getId(TwitchHelix helix, OAuth2Credential token, @NotNull String name, @Nullable String optimisticId) {
        if (optimisticId != null) {
            return optimisticId;
        }
        if (name.equalsIgnoreCase(token.getUserName())) {
            return token.getUserId();
        }
        String cachedId = USER_ID_BY_LOGIN_CACHE.get(name.toLowerCase());
        if (cachedId != null) {
            return cachedId;
        }
        User user = helix.getUsers(token.getAccessToken(), null, Collections.singletonList(name)).execute().getUsers().get(0);
        USER_ID_BY_LOGIN_CACHE.put(user.getLogin(), user.getId());
        return user.getId();
    }

    private static void doBan(TwitchHelix helix, OAuth2Credential token, String channelId, String targetId, String reason, Integer duration) {
        if (channelId == null || targetId == null || duration != null && duration == 0) {
            return;
        }
        helix.banUser(token.getAccessToken(), channelId, token.getUserId(), BanUserInput.builder().userId(targetId).reason(reason != null ? reason : "").duration(duration).build()).execute();
    }

    @Nullable
    static Integer parseDuration(@NotNull String time) {
        int seconds = 0;
        int part = 0;
        int n = time.length();
        block7: for (int i = 0; i < n; ++i) {
            char c = time.charAt(i);
            if (Character.isDigit(c)) {
                part *= 10;
                part += c - 48;
                continue;
            }
            if (i == 0 && c != ' ') {
                return null;
            }
            switch (Character.toLowerCase(c)) {
                case 's': {
                    seconds += part;
                    break;
                }
                case 'm': {
                    if (i + 1 < n && Character.toLowerCase(time.charAt(i + 1)) == 'o') {
                        seconds += part * 60 * 60 * 24 * 7 * 4;
                        break;
                    }
                    seconds += part * 60;
                    break;
                }
                case 'h': {
                    seconds += part * 60 * 60;
                    break;
                }
                case 'd': {
                    seconds += part * 60 * 60 * 24;
                    break;
                }
                case 'w': {
                    seconds += part * 60 * 60 * 24 * 7;
                    break;
                }
                default: {
                    if (part <= 0) break;
                    if (c == ' ') continue block7;
                    return null;
                }
            }
            part = 0;
        }
        return seconds += part;
    }

    @Generated
    public Map<String, ChatCommandHandler> getCommandHandlers() {
        return this.commandHandlers;
    }

    static {
        log = LoggerFactory.getLogger(ChatCommandRegistry.class);
        HELIX_COLORS_BY_LOWER_CHAT_NAME = EnumUtil.buildMapping((Enum[])NamedUserChatColor.values(), c -> c.toString().replace("_", ""), Enum::toString);
        USER_ID_BY_LOGIN_CACHE = CacheApi.create(spec -> {
            spec.expiryType(ExpiryType.POST_ACCESS);
            spec.expiryTime(Duration.ofMinutes(5L));
            spec.maxSize(2048L);
        });
    }
}

