/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.kraken;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.common.config.ProxyConfig;
import com.morelaid.streamingmodule.external.twitch4j.common.config.Twitch4JGlobal;
import com.morelaid.streamingmodule.external.twitch4j.common.feign.interceptor.JsonContentTypeHeaderInterceptor;
import com.morelaid.streamingmodule.external.twitch4j.common.feign.interceptor.TwitchClientIdInterceptor;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.kraken.TwitchKraken;
import com.morelaid.streamingmodule.external.twitch4j.kraken.TwitchKrakenErrorDecoder;
import com.netflix.config.ConfigurationManager;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.Retryer;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
public class TwitchKrakenBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchKrakenBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://api.twitch.tv/kraken";
    private Integer timeout = 5000;
    private Integer uploadTimeout = 240000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;

    public static TwitchKrakenBuilder builder() {
        return new TwitchKrakenBuilder();
    }

    @Deprecated
    public TwitchKraken build() {
        log.warn("Kraken is deprecated and has been shut down on Febuary 28, 2022.");
        log.warn("More details about the decommission are available here: https://blog.twitch.tv/en/2021/07/15/legacy-twitch-api-v5-shutdown-details-and-timeline");
        log.debug("Kraken: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#uploadVideoPart(URI,String,String,int,byte[]).execution.isolation.thread.timeoutInMilliseconds", this.uploadTimeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getChatEmoticonsBySet(Collection).execution.isolation.thread.timeoutInMilliseconds", this.timeout * 2);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getChatEmoticons().execution.isolation.thread.timeoutInMilliseconds", this.timeout * 4);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.TwitchKraken#getAllChatEmoticons().execution.isolation.thread.timeoutInMilliseconds", this.timeout * 8);
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("Kraken: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        return ((Feign.Builder)HystrixFeign.builder().client(new OkHttpClient(clientBuilder.build())).encoder(new JacksonEncoder(mapper)).decoder(new JacksonDecoder(mapper)).logger(new Slf4jLogger()).logLevel(this.logLevel).errorDecoder(new TwitchKrakenErrorDecoder(new JacksonDecoder())).requestInterceptor(new TwitchClientIdInterceptor(this.clientId, this.userAgent)).requestInterceptor(t2 -> t2.header("Accept", "application/vnd.twitchtv.v5+json")).requestInterceptor(new JsonContentTypeHeaderInterceptor()).options(new Request.Options(this.timeout / 3, TimeUnit.MILLISECONDS, this.timeout.intValue(), TimeUnit.MILLISECONDS, true)).retryer(new Retryer.Default(500L, this.timeout.intValue(), 2))).target(TwitchKraken.class, this.baseUrl);
    }

    @Generated
    private TwitchKrakenBuilder() {
    }

    @Generated
    private TwitchKrakenBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String baseUrl, Integer timeout2, Integer uploadTimeout, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout2;
        this.uploadTimeout = uploadTimeout;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public Integer getUploadTimeout() {
        return this.uploadTimeout;
    }

    @Generated
    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public TwitchKrakenBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchKrakenBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchKrakenBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withBaseUrl(String baseUrl) {
        return this.baseUrl == baseUrl ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, baseUrl, this.timeout, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withTimeout(Integer timeout2) {
        return this.timeout == timeout2 ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, timeout2, this.uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withUploadTimeout(Integer uploadTimeout) {
        return this.uploadTimeout == uploadTimeout ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, uploadTimeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchKrakenBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchKrakenBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.uploadTimeout, this.logLevel, proxyConfig);
    }
}

