/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.domain;

import com.morelaid.streamingmodule.external.jackson.annotation.JsonProperty;
import com.morelaid.streamingmodule.external.jackson.databind.annotation.JsonDeserialize;
import com.morelaid.streamingmodule.external.twitch4j.common.util.DonationAmount;
import com.morelaid.streamingmodule.external.twitch4j.common.util.MilliInstantDeserializer;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.AutomodCaughtMessage;
import java.time.Instant;
import java.util.List;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;

public class PinnedMessage {
    @JsonProperty(value="id")
    private String messageId;
    private AutomodCaughtMessage.Sender sender;
    private Content content;
    private String type;
    @JsonDeserialize(using=MilliInstantDeserializer.class)
    private Instant startsAt;
    @JsonDeserialize(using=MilliInstantDeserializer.class)
    private Instant updatedAt;
    @JsonDeserialize(using=MilliInstantDeserializer.class)
    private Instant endsAt;
    @JsonDeserialize(using=MilliInstantDeserializer.class)
    private Instant sentAt;
    @JsonProperty(value="metadata")
    @Nullable
    private DonationAmount hypeMetadata;

    public boolean isHypeChat() {
        return "PAID".equalsIgnoreCase(this.type);
    }

    public boolean isModPin() {
        return "MOD".equalsIgnoreCase(this.type);
    }

    @Generated
    public PinnedMessage() {
    }

    @Generated
    public String getMessageId() {
        return this.messageId;
    }

    @Generated
    public AutomodCaughtMessage.Sender getSender() {
        return this.sender;
    }

    @Generated
    public Content getContent() {
        return this.content;
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public Instant getStartsAt() {
        return this.startsAt;
    }

    @Generated
    public Instant getUpdatedAt() {
        return this.updatedAt;
    }

    @Generated
    public Instant getEndsAt() {
        return this.endsAt;
    }

    @Generated
    public Instant getSentAt() {
        return this.sentAt;
    }

    @Nullable
    @Generated
    public DonationAmount getHypeMetadata() {
        return this.hypeMetadata;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PinnedMessage)) {
            return false;
        }
        PinnedMessage other = (PinnedMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$messageId = this.getMessageId();
        String other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !this$messageId.equals(other$messageId)) {
            return false;
        }
        AutomodCaughtMessage.Sender this$sender = this.getSender();
        AutomodCaughtMessage.Sender other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !((Object)this$sender).equals(other$sender)) {
            return false;
        }
        Content this$content = this.getContent();
        Content other$content = other.getContent();
        if (this$content == null ? other$content != null : !((Object)this$content).equals(other$content)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Instant this$startsAt = this.getStartsAt();
        Instant other$startsAt = other.getStartsAt();
        if (this$startsAt == null ? other$startsAt != null : !((Object)this$startsAt).equals(other$startsAt)) {
            return false;
        }
        Instant this$updatedAt = this.getUpdatedAt();
        Instant other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        Instant this$endsAt = this.getEndsAt();
        Instant other$endsAt = other.getEndsAt();
        if (this$endsAt == null ? other$endsAt != null : !((Object)this$endsAt).equals(other$endsAt)) {
            return false;
        }
        Instant this$sentAt = this.getSentAt();
        Instant other$sentAt = other.getSentAt();
        if (this$sentAt == null ? other$sentAt != null : !((Object)this$sentAt).equals(other$sentAt)) {
            return false;
        }
        DonationAmount this$hypeMetadata = this.getHypeMetadata();
        DonationAmount other$hypeMetadata = other.getHypeMetadata();
        return !(this$hypeMetadata == null ? other$hypeMetadata != null : !((Object)this$hypeMetadata).equals(other$hypeMetadata));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PinnedMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : $messageId.hashCode());
        AutomodCaughtMessage.Sender $sender = this.getSender();
        result = result * 59 + ($sender == null ? 43 : ((Object)$sender).hashCode());
        Content $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : ((Object)$content).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Instant $startsAt = this.getStartsAt();
        result = result * 59 + ($startsAt == null ? 43 : ((Object)$startsAt).hashCode());
        Instant $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        Instant $endsAt = this.getEndsAt();
        result = result * 59 + ($endsAt == null ? 43 : ((Object)$endsAt).hashCode());
        Instant $sentAt = this.getSentAt();
        result = result * 59 + ($sentAt == null ? 43 : ((Object)$sentAt).hashCode());
        DonationAmount $hypeMetadata = this.getHypeMetadata();
        result = result * 59 + ($hypeMetadata == null ? 43 : ((Object)$hypeMetadata).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PinnedMessage(messageId=" + this.getMessageId() + ", sender=" + this.getSender() + ", content=" + this.getContent() + ", type=" + this.getType() + ", startsAt=" + this.getStartsAt() + ", updatedAt=" + this.getUpdatedAt() + ", endsAt=" + this.getEndsAt() + ", sentAt=" + this.getSentAt() + ", hypeMetadata=" + this.getHypeMetadata() + ")";
    }

    @JsonProperty(value="id")
    @Generated
    private void setMessageId(String messageId) {
        this.messageId = messageId;
    }

    @Generated
    private void setSender(AutomodCaughtMessage.Sender sender) {
        this.sender = sender;
    }

    @Generated
    private void setContent(Content content) {
        this.content = content;
    }

    @Generated
    private void setType(String type) {
        this.type = type;
    }

    @JsonDeserialize(using=MilliInstantDeserializer.class)
    @Generated
    private void setStartsAt(Instant startsAt) {
        this.startsAt = startsAt;
    }

    @JsonDeserialize(using=MilliInstantDeserializer.class)
    @Generated
    private void setUpdatedAt(Instant updatedAt) {
        this.updatedAt = updatedAt;
    }

    @JsonDeserialize(using=MilliInstantDeserializer.class)
    @Generated
    private void setEndsAt(Instant endsAt) {
        this.endsAt = endsAt;
    }

    @JsonDeserialize(using=MilliInstantDeserializer.class)
    @Generated
    private void setSentAt(Instant sentAt) {
        this.sentAt = sentAt;
    }

    @JsonProperty(value="metadata")
    @Generated
    private void setHypeMetadata(@Nullable DonationAmount hypeMetadata) {
        this.hypeMetadata = hypeMetadata;
    }

    public static class Content {
        private String text;
        private List<AutomodCaughtMessage.Fragment> fragments;

        @Generated
        public Content() {
        }

        @Generated
        public String getText() {
            return this.text;
        }

        @Generated
        public List<AutomodCaughtMessage.Fragment> getFragments() {
            return this.fragments;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Content)) {
                return false;
            }
            Content other = (Content)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$text = this.getText();
            String other$text = other.getText();
            if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
                return false;
            }
            List<AutomodCaughtMessage.Fragment> this$fragments = this.getFragments();
            List<AutomodCaughtMessage.Fragment> other$fragments = other.getFragments();
            return !(this$fragments == null ? other$fragments != null : !((Object)this$fragments).equals(other$fragments));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Content;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $text = this.getText();
            result = result * 59 + ($text == null ? 43 : $text.hashCode());
            List<AutomodCaughtMessage.Fragment> $fragments = this.getFragments();
            result = result * 59 + ($fragments == null ? 43 : ((Object)$fragments).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "PinnedMessage.Content(text=" + this.getText() + ", fragments=" + this.getFragments() + ")";
        }

        @Generated
        private void setText(String text) {
            this.text = text;
        }

        @Generated
        private void setFragments(List<AutomodCaughtMessage.Fragment> fragments) {
            this.fragments = fragments;
        }
    }
}

