/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.OutboundFollow;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.OutboundUnfollow;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.OutboundFollowPubSubEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.OutboundUnfollowPubSubEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class FollowsHandler
implements TopicHandler {
    FollowsHandler() {
    }

    @Override
    public String topicName() {
        return "follows";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length <= 1) {
            return null;
        }
        String selfId = topicParts[1];
        switch (args2.getType()) {
            case "user-followed": {
                OutboundFollow follow = TypeConvert.jsonToObject(args2.getRawMessage(), OutboundFollow.class);
                return new OutboundFollowPubSubEvent(selfId, follow);
            }
            case "user-unfollowed": {
                OutboundUnfollow unfollow = TypeConvert.jsonToObject(args2.getRawMessage(), OutboundUnfollow.class);
                return new OutboundUnfollowPubSubEvent(selfId, unfollow);
            }
        }
        return null;
    }
}

