/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ClipsLeaderboard;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.Leaderboard;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.BitsLeaderboardEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ClipsLeaderboardEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SubLeaderboardEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class LeaderboardHandler
implements TopicHandler {
    LeaderboardHandler() {
    }

    @Override
    public String topicName() {
        return "leaderboard-events-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        if (args2.getLastTopicPart().startsWith("clips-")) {
            ClipsLeaderboard clipsLeaderboard = TypeConvert.jsonToObject(args2.getRawMessage(), ClipsLeaderboard.class);
            return new ClipsLeaderboardEvent(clipsLeaderboard);
        }
        Leaderboard leaderboard = TypeConvert.jsonToObject(args2.getRawMessage(), Leaderboard.class);
        switch (leaderboard.getIdentifier().getDomain()) {
            case "bits-usage-by-channel-v1": {
                return new BitsLeaderboardEvent(leaderboard);
            }
            case "sub-gifts-sent": {
                return new SubLeaderboardEvent(leaderboard);
            }
        }
        return null;
    }
}

