/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.SharedChatSession;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SharedChatSessionCreatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SharedChatSessionEndedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SharedChatSessionStartedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SharedChatSessionUpdatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;
import java.time.Instant;

class SharedChatHandler
implements TopicHandler {
    SharedChatHandler() {
    }

    @Override
    public String topicName() {
        return "shared-chat-channel-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String channelId = args2.getLastTopicPart();
        Instant ts = Instant.parse(args2.getData().get("timestamp").textValue());
        SharedChatSession session = TypeConvert.convertValue((Object)args2.getData().path("session"), SharedChatSession.class);
        switch (args2.getType()) {
            case "session-created": {
                return new SharedChatSessionCreatedEvent(channelId, ts, session);
            }
            case "session-started": {
                return new SharedChatSessionStartedEvent(channelId, ts, session);
            }
            case "session-updated": {
                return new SharedChatSessionUpdatedEvent(channelId, ts, session);
            }
            case "session-ended": {
                return new SharedChatSessionEndedEvent(channelId, ts, session);
            }
        }
        return null;
    }
}

