/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.BannedTermAdded;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.BannedTermRemoved;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ShieldModeSettings;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ShieldModeStatus;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ShieldModeBannedTermAddedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ShieldModeBannedTermRemovedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ShieldModeSettingsUpdatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ShieldModeStatusUpdatedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class ShieldHandler
implements TopicHandler {
    ShieldHandler() {
    }

    @Override
    public String topicName() {
        return "shield-mode";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length != 3) {
            return null;
        }
        String userId = topicParts[1];
        String channelId = topicParts[2];
        JsonNode msgData = args2.getData();
        switch (args2.getType()) {
            case "ADD_AUTOBAN_TERM": {
                BannedTermAdded termAdded = TypeConvert.convertValue((Object)msgData, BannedTermAdded.class);
                return new ShieldModeBannedTermAddedEvent(userId, channelId, termAdded);
            }
            case "REMOVE_AUTOBAN_TERM": {
                BannedTermRemoved termRemoved = TypeConvert.convertValue((Object)msgData, BannedTermRemoved.class);
                return new ShieldModeBannedTermRemovedEvent(userId, channelId, termRemoved);
            }
            case "UPDATE_CHANNEL_MODERATION_MODE": {
                ShieldModeStatus shieldModeStatus = TypeConvert.convertValue((Object)msgData, ShieldModeStatus.class);
                return new ShieldModeStatusUpdatedEvent(userId, channelId, shieldModeStatus);
            }
            case "UPDATE_CHANNEL_MODERATION_SETTINGS": {
                ShieldModeSettings shieldModeSettings = TypeConvert.convertValue((Object)msgData, ShieldModeSettings.class);
                return new ShieldModeSettingsUpdatedEvent(userId, channelId, shieldModeSettings);
            }
            case "UPDATE_CHANNEL_MODERATION_MODE_SHORTCUT": {
                return new TwitchEvent(){};
            }
        }
        return null;
    }
}

