/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.BanSharingSettings;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.LowTrustUserNewMessage;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.LowTrustUserTreatmentUpdate;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.BanSharingSettingsUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.LowTrustUserNewMessageEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.LowTrustUserTreatmentUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class SuspiciousHandler
implements TopicHandler {
    SuspiciousHandler() {
    }

    @Override
    public String topicName() {
        return "low-trust-users";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length != 3) {
            return null;
        }
        String userId = topicParts[1];
        String channelId = topicParts[2];
        String type = args2.getType();
        JsonNode msgData = args2.getData();
        if ("low_trust_user_new_message".equals(type)) {
            return new LowTrustUserNewMessageEvent(userId, channelId, TypeConvert.convertValue((Object)msgData, LowTrustUserNewMessage.class));
        }
        if ("low_trust_user_treatment_update".equals(type)) {
            return new LowTrustUserTreatmentUpdateEvent(userId, channelId, TypeConvert.convertValue((Object)msgData, LowTrustUserTreatmentUpdate.class));
        }
        if ("bans_sharing_settings_update".equals(type)) {
            return new BanSharingSettingsUpdateEvent(userId, channelId, TypeConvert.convertValue((Object)msgData, BanSharingSettings.class));
        }
        return null;
    }
}

