/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeLevelUp;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeProgression;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeTrainApproaching;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeTrainConductor;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeTrainEnd;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeTrainRewardsData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.HypeTrainStart;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.SupportActivityFeedData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainApproachingEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainConductorUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainCooldownExpirationEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainEndEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainLevelUpEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainProgressionEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainRewardsEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.HypeTrainStartEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.SupportActivityFeedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;
import java.util.Arrays;
import java.util.Collection;

class TrainHandler
implements TopicHandler {
    TrainHandler() {
    }

    @Override
    public String topicName() {
        return "hype-train-events-v2";
    }

    @Override
    public Collection<String> topicNames() {
        return Arrays.asList(this.topicName(), "hype-train-events-v1");
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length > 2 && "rewards".equals(topicParts[1])) {
            return new HypeTrainRewardsEvent(TypeConvert.convertValue((Object)args2.getData(), HypeTrainRewardsData.class));
        }
        JsonNode msgData = args2.getData();
        String lastTopicIdentifier = args2.getLastTopicPart();
        switch (args2.getType()) {
            case "hype-train-approaching": {
                HypeTrainApproaching approachData = TypeConvert.convertValue((Object)msgData, HypeTrainApproaching.class);
                return new HypeTrainApproachingEvent(approachData);
            }
            case "hype-train-start": {
                HypeTrainStart startData = TypeConvert.convertValue((Object)msgData, HypeTrainStart.class);
                return new HypeTrainStartEvent(lastTopicIdentifier, startData);
            }
            case "hype-train-progression": {
                HypeProgression progressionData = TypeConvert.convertValue((Object)msgData, HypeProgression.class);
                return new HypeTrainProgressionEvent(lastTopicIdentifier, progressionData);
            }
            case "hype-train-level-up": {
                HypeLevelUp levelUpData = TypeConvert.convertValue((Object)msgData, HypeLevelUp.class);
                return new HypeTrainLevelUpEvent(lastTopicIdentifier, levelUpData);
            }
            case "hype-train-end": {
                HypeTrainEnd endData = TypeConvert.convertValue((Object)msgData, HypeTrainEnd.class);
                return new HypeTrainEndEvent(lastTopicIdentifier, endData);
            }
            case "hype-train-conductor-update": {
                HypeTrainConductor conductorData = TypeConvert.convertValue((Object)msgData, HypeTrainConductor.class);
                return new HypeTrainConductorUpdateEvent(lastTopicIdentifier, conductorData);
            }
            case "hype-train-cooldown-expiration": {
                return new HypeTrainCooldownExpirationEvent(lastTopicIdentifier);
            }
            case "last-x-experiment-event": {
                SupportActivityFeedData lastData = TypeConvert.convertValue((Object)msgData, SupportActivityFeedData.class);
                return new SupportActivityFeedEvent(lastTopicIdentifier, lastData);
            }
        }
        return null;
    }
}

