/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.CreatedUnbanRequest;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.UpdatedUnbanRequest;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ChannelUnbanRequestCreateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ChannelUnbanRequestUpdateEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;

class UnbanRequestHandler
implements TopicHandler {
    UnbanRequestHandler() {
    }

    @Override
    public String topicName() {
        return "channel-unban-requests";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        String[] topicParts = args2.getTopicParts();
        if (topicParts.length != 3) {
            return null;
        }
        String userId = topicParts[1];
        String channelId = topicParts[2];
        if ("create_unban_request".equals(args2.getType())) {
            CreatedUnbanRequest request = TypeConvert.convertValue((Object)args2.getData(), CreatedUnbanRequest.class);
            return new ChannelUnbanRequestCreateEvent(userId, channelId, request);
        }
        if ("update_unban_request".equals(args2.getType())) {
            UpdatedUnbanRequest request = TypeConvert.convertValue((Object)args2.getData(), UpdatedUnbanRequest.class);
            return new ChannelUnbanRequestUpdateEvent(userId, channelId, request);
        }
        return null;
    }
}

