/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers;

import com.morelaid.streamingmodule.external.jackson.databind.JsonNode;
import com.morelaid.streamingmodule.external.twitch4j.common.events.TwitchEvent;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ChannelPointsEarned;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ChannelPointsRedemption;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.ClaimData;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.CommunityGoalContribution;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.domain.PointsSpent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ClaimAvailableEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.ClaimClaimedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.PointsEarnedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.PointsSpentEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.RewardRedeemedEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.events.UserCommunityGoalContributionEvent;
import com.morelaid.streamingmodule.external.twitch4j.pubsub.handlers.TopicHandler;
import java.time.Instant;

class UserPointsHandler
implements TopicHandler {
    UserPointsHandler() {
    }

    @Override
    public String topicName() {
        return "community-points-user-v1";
    }

    @Override
    public TwitchEvent apply(TopicHandler.Args args2) {
        JsonNode msgData = args2.getData();
        switch (args2.getType()) {
            case "points-earned": {
                ChannelPointsEarned pointsEarned = TypeConvert.convertValue((Object)msgData, ChannelPointsEarned.class);
                return new PointsEarnedEvent(pointsEarned);
            }
            case "claim-available": {
                ClaimData claimAvailable = TypeConvert.convertValue((Object)msgData, ClaimData.class);
                return new ClaimAvailableEvent(claimAvailable);
            }
            case "claim-claimed": {
                ClaimData claimClaimed = TypeConvert.convertValue((Object)msgData, ClaimData.class);
                return new ClaimClaimedEvent(claimClaimed);
            }
            case "points-spent": {
                PointsSpent pointsSpent = TypeConvert.convertValue((Object)msgData, PointsSpent.class);
                return new PointsSpentEvent(pointsSpent);
            }
            case "reward-redeemed": {
                ChannelPointsRedemption redemption = TypeConvert.convertValue((Object)msgData.path("redemption"), ChannelPointsRedemption.class);
                return new RewardRedeemedEvent(Instant.parse(msgData.path("timestamp").asText()), redemption);
            }
            case "community-goal-contribution": {
                CommunityGoalContribution goal = TypeConvert.convertValue((Object)msgData.path("contribution"), CommunityGoalContribution.class);
                Instant instant = Instant.parse(msgData.path("timestamp").textValue());
                return new UserCommunityGoalContributionEvent(args2.getLastTopicPart(), instant, goal);
            }
            case "global-last-viewed-content-updated": 
            case "channel-last-viewed-content-updated": {
                return new TwitchEvent(){};
            }
        }
        return null;
    }
}

