/*
 * Decompiled with CFR 0.152.
 */
package com.morelaid.streamingmodule.external.twitch4j.tmi;

import com.morelaid.streamingmodule.external.jackson.databind.ObjectMapper;
import com.morelaid.streamingmodule.external.twitch4j.common.config.ProxyConfig;
import com.morelaid.streamingmodule.external.twitch4j.common.config.Twitch4JGlobal;
import com.morelaid.streamingmodule.external.twitch4j.common.feign.interceptor.TwitchClientIdInterceptor;
import com.morelaid.streamingmodule.external.twitch4j.common.util.TypeConvert;
import com.morelaid.streamingmodule.external.twitch4j.tmi.TwitchMessagingInterface;
import com.morelaid.streamingmodule.external.twitch4j.tmi.TwitchMessagingInterfaceErrorDecoder;
import com.netflix.config.ConfigurationManager;
import feign.Feign;
import feign.Logger;
import feign.Request;
import feign.Retryer;
import feign.hystrix.HystrixFeign;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.okhttp.OkHttpClient;
import feign.slf4j.Slf4jLogger;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.0.0")
public class TwitchMessagingInterfaceBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TwitchMessagingInterfaceBuilder.class);
    private String clientId = Twitch4JGlobal.clientId;
    private String clientSecret = Twitch4JGlobal.clientSecret;
    private String userAgent = Twitch4JGlobal.userAgent;
    private Integer requestQueueSize = -1;
    private String baseUrl = "https://tmi.twitch.tv";
    private Integer timeout = 5000;
    private Logger.Level logLevel = Logger.Level.NONE;
    private ProxyConfig proxyConfig = null;

    public static TwitchMessagingInterfaceBuilder builder() {
        return new TwitchMessagingInterfaceBuilder();
    }

    @Deprecated
    public TwitchMessagingInterface build() {
        log.debug("TMI: Initializing Module ...");
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.execution.isolation.thread.timeoutInMilliseconds", this.timeout);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.command.default.requestCache.enabled", false);
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.maxQueueSize", this.getRequestQueueSize());
        ConfigurationManager.getConfigInstance().setProperty("hystrix.threadpool.default.queueSizeRejectionThreshold", this.getRequestQueueSize());
        if (this.logLevel == Logger.Level.HEADERS || this.logLevel == Logger.Level.FULL) {
            log.warn("TMI: The current feign loglevel will print sensitive information including your access token, please don't share this log!");
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.proxyConfig != null) {
            this.proxyConfig.apply(clientBuilder);
        }
        ObjectMapper mapper = TypeConvert.getObjectMapper();
        TwitchMessagingInterface client = ((Feign.Builder)HystrixFeign.builder().client(new OkHttpClient(clientBuilder.build())).encoder(new JacksonEncoder(mapper)).decoder(new JacksonDecoder(mapper)).logger(new Slf4jLogger()).logLevel(this.logLevel).errorDecoder(new TwitchMessagingInterfaceErrorDecoder(new JacksonDecoder())).requestInterceptor(new TwitchClientIdInterceptor(this.clientId, this.userAgent)).retryer(new Retryer.Default(1L, 10000L, 3)).options(new Request.Options(5000L, TimeUnit.MILLISECONDS, 15000L, TimeUnit.MILLISECONDS, true))).target(TwitchMessagingInterface.class, this.baseUrl);
        return client;
    }

    @Generated
    private TwitchMessagingInterfaceBuilder() {
    }

    @Generated
    private TwitchMessagingInterfaceBuilder(String clientId, String clientSecret, String userAgent, Integer requestQueueSize, String baseUrl, Integer timeout2, Logger.Level logLevel, ProxyConfig proxyConfig) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.userAgent = userAgent;
        this.requestQueueSize = requestQueueSize;
        this.baseUrl = baseUrl;
        this.timeout = timeout2;
        this.logLevel = logLevel;
        this.proxyConfig = proxyConfig;
    }

    @Generated
    public String getClientId() {
        return this.clientId;
    }

    @Generated
    public String getClientSecret() {
        return this.clientSecret;
    }

    @Generated
    public String getUserAgent() {
        return this.userAgent;
    }

    @Generated
    public Integer getRequestQueueSize() {
        return this.requestQueueSize;
    }

    @Generated
    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Generated
    public Integer getTimeout() {
        return this.timeout;
    }

    @Generated
    public Logger.Level getLogLevel() {
        return this.logLevel;
    }

    @Generated
    public ProxyConfig getProxyConfig() {
        return this.proxyConfig;
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withClientId(String clientId) {
        return this.clientId == clientId ? this : new TwitchMessagingInterfaceBuilder(clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withClientSecret(String clientSecret) {
        return this.clientSecret == clientSecret ? this : new TwitchMessagingInterfaceBuilder(this.clientId, clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withUserAgent(String userAgent) {
        return this.userAgent == userAgent ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withRequestQueueSize(Integer requestQueueSize) {
        return this.requestQueueSize == requestQueueSize ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, requestQueueSize, this.baseUrl, this.timeout, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withTimeout(Integer timeout2) {
        return this.timeout == timeout2 ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, timeout2, this.logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withLogLevel(Logger.Level logLevel) {
        return this.logLevel == logLevel ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, logLevel, this.proxyConfig);
    }

    @Generated
    public TwitchMessagingInterfaceBuilder withProxyConfig(ProxyConfig proxyConfig) {
        return this.proxyConfig == proxyConfig ? this : new TwitchMessagingInterfaceBuilder(this.clientId, this.clientSecret, this.userAgent, this.requestQueueSize, this.baseUrl, this.timeout, this.logLevel, proxyConfig);
    }
}

