/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.jdbc;

import com.mysql.cj.Messages;
import com.mysql.cj.exceptions.CJException;
import com.mysql.cj.exceptions.ExceptionInterceptor;
import com.mysql.cj.jdbc.ConnectionWrapper;
import com.mysql.cj.jdbc.JdbcConnection;
import com.mysql.cj.jdbc.exceptions.SQLError;
import com.mysql.cj.jdbc.exceptions.SQLExceptionsMapping;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEvent;
import javax.sql.StatementEventListener;

public class MysqlPooledConnection
implements PooledConnection {
    public static final int CONNECTION_ERROR_EVENT = 1;
    public static final int CONNECTION_CLOSED_EVENT = 2;
    private Map<ConnectionEventListener, ConnectionEventListener> connectionEventListeners;
    private Connection logicalHandle = null;
    private JdbcConnection physicalConn;
    private ExceptionInterceptor exceptionInterceptor;
    private final Map<StatementEventListener, StatementEventListener> statementEventListeners = new HashMap<StatementEventListener, StatementEventListener>();
    private final Lock statementEventListenersLock = new ReentrantLock();
    protected final Lock lock = new ReentrantLock();

    protected static MysqlPooledConnection getInstance(JdbcConnection connection) throws SQLException {
        return new MysqlPooledConnection(connection);
    }

    public MysqlPooledConnection(JdbcConnection connection) {
        this.physicalConn = connection;
        this.connectionEventListeners = new HashMap<ConnectionEventListener, ConnectionEventListener>();
        this.exceptionInterceptor = this.physicalConn.getExceptionInterceptor();
    }

    public Lock getLock() {
        return this.lock;
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        this.lock.lock();
        try {
            if (this.connectionEventListeners != null) {
                this.connectionEventListeners.put(connectioneventlistener, connectioneventlistener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener connectioneventlistener) {
        this.lock.lock();
        try {
            if (this.connectionEventListeners != null) {
                this.connectionEventListeners.remove(connectioneventlistener);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        try {
            this.lock.lock();
            try {
                Connection connection = this.getConnection(true, false);
                return connection;
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Connection getConnection(boolean resetServerState, boolean forXa) throws SQLException {
        this.lock.lock();
        try {
            if (this.physicalConn == null) {
                SQLException sqlException = SQLError.createSQLException(Messages.getString("MysqlPooledConnection.0"), this.exceptionInterceptor);
                this.callConnectionEventListeners(1, sqlException);
                throw sqlException;
            }
            try {
                if (this.logicalHandle != null) {
                    ((ConnectionWrapper)this.logicalHandle).close(false);
                }
                if (resetServerState) {
                    this.physicalConn.resetServerState();
                }
                this.logicalHandle = ConnectionWrapper.getInstance(this, this.physicalConn, forXa);
            }
            catch (SQLException sqlException) {
                this.callConnectionEventListeners(1, sqlException);
                throw sqlException;
            }
            Connection connection = this.logicalHandle;
            return connection;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void close() throws SQLException {
        try {
            this.lock.lock();
            try {
                if (this.physicalConn != null) {
                    this.physicalConn.close();
                    this.physicalConn = null;
                }
                if (this.connectionEventListeners != null) {
                    this.connectionEventListeners.clear();
                    this.connectionEventListeners = null;
                }
                this.statementEventListeners.clear();
            }
            finally {
                this.lock.unlock();
            }
            return;
        }
        catch (CJException cJException) {
            throw SQLExceptionsMapping.translateException(cJException, this.exceptionInterceptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void callConnectionEventListeners(int eventType, SQLException sqlException) {
        this.lock.lock();
        try {
            if (this.connectionEventListeners == null) {
                return;
            }
            Iterator<Map.Entry<ConnectionEventListener, ConnectionEventListener>> iterator2 = this.connectionEventListeners.entrySet().iterator();
            ConnectionEvent connectionevent = new ConnectionEvent(this, sqlException);
            while (iterator2.hasNext()) {
                ConnectionEventListener connectioneventlistener = iterator2.next().getValue();
                if (eventType == 2) {
                    connectioneventlistener.connectionClosed(connectionevent);
                    continue;
                }
                if (eventType != 1) continue;
                connectioneventlistener.connectionErrorOccurred(connectionevent);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected ExceptionInterceptor getExceptionInterceptor() {
        return this.exceptionInterceptor;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        this.statementEventListenersLock.lock();
        try {
            this.statementEventListeners.put(listener, listener);
        }
        finally {
            this.statementEventListenersLock.unlock();
        }
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        this.statementEventListenersLock.lock();
        try {
            this.statementEventListeners.remove(listener);
        }
        finally {
            this.statementEventListenersLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireStatementEvent(StatementEvent event) throws SQLException {
        this.statementEventListenersLock.lock();
        try {
            for (StatementEventListener listener : this.statementEventListeners.keySet()) {
                listener.statementClosed(event);
            }
        }
        finally {
            this.statementEventListenersLock.unlock();
        }
    }
}

