/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config;

import com.netflix.config.ConcurrentMapConfiguration;
import com.netflix.config.ConfigurationManager;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathPropertiesConfiguration
extends ConcurrentMapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ClasspathPropertiesConfiguration.class);
    static String configNameProperty = "config.configName";
    static String propertiesResourceRelativePath = "META-INF/conf/config.properties";
    static ClasspathPropertiesConfiguration instance = null;

    private ClasspathPropertiesConfiguration() {
    }

    public String getConfigNameProperty() {
        return configNameProperty;
    }

    public static void setConfigNameProperty(String string) {
        configNameProperty = string;
    }

    public String getPropertiesResourceRelativePath() {
        return propertiesResourceRelativePath;
    }

    public static void setPropertiesResourceRelativePath(String string) {
        propertiesResourceRelativePath = string;
    }

    @Override
    public Properties getProperties() {
        return instance != null ? instance.getProperties() : new Properties();
    }

    public static void initialize() {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            instance = new ClasspathPropertiesConfiguration();
            ClasspathPropertiesConfiguration.loadResources(classLoader, propertiesResourceRelativePath);
        }
        catch (Exception exception) {
            throw new RuntimeException("failed to read configuration properties from classpath", exception);
        }
    }

    private static void loadResources(ClassLoader classLoader, String string) throws Exception {
        Enumeration<URL> enumeration = classLoader.getResources(string);
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            URL uRL = enumeration.nextElement();
            ConfigurationManager.loadPropertiesFromResources(uRL.getPath());
            log.debug("Added properties from:" + uRL + uRL.getPath());
            bl = true;
        }
        if (!bl) {
            log.debug("Did not find any properties resource in the classpath with name:" + propertiesResourceRelativePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(URL uRL) throws IOException {
        Properties properties = new Properties();
        InputStream inputStream2 = uRL.openStream();
        try {
            properties.load(inputStream2);
        }
        catch (Exception exception) {
            log.error("Exception while loading properties from URL:" + uRL);
        }
        finally {
            inputStream2.close();
        }
        return properties;
    }

    private static String getConfigName(Properties properties, URL uRL) {
        String string = properties.getProperty(configNameProperty);
        if (string == null) {
            string = uRL.toExternalForm();
            string = string.replace('\\', '/');
            String string2 = uRL.getProtocol().toLowerCase();
            if ("jar".equals(string2) || "zip".equals(string2)) {
                int n;
                int n2 = string.lastIndexOf("!");
                if (n2 >= 0) {
                    string = string.substring(0, n2);
                }
                if ((n = string.lastIndexOf("/")) >= 0) {
                    string = string.substring(n + 1);
                }
            } else {
                int n = string.lastIndexOf("/");
                if (n >= 0) {
                    string = string.substring(0, n);
                }
            }
        }
        return string;
    }
}

