/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.config.sources;

import com.netflix.config.PollResult;
import com.netflix.config.PolledConfigurationSource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URLConfigurationSource
implements PolledConfigurationSource {
    private final URL[] configUrls;
    public static final String CONFIG_URL = "archaius.configurationSource.additionalUrls";
    public static final String DEFAULT_CONFIG_FILE_NAME = "config.properties";
    public static final String DEFAULT_CONFIG_FILE_FROM_CLASSPATH = System.getProperty("archaius.configurationSource.defaultFileName") == null ? "config.properties" : System.getProperty("archaius.configurationSource.defaultFileName");
    private static final Logger logger = LoggerFactory.getLogger(URLConfigurationSource.class);

    public URLConfigurationSource(String ... stringArray) {
        this.configUrls = URLConfigurationSource.createUrls(stringArray);
    }

    private static URL[] createUrls(String ... stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            throw new IllegalArgumentException("urlStrings is null or empty");
        }
        URL[] uRLArray = new URL[stringArray.length];
        try {
            for (int i = 0; i < uRLArray.length; ++i) {
                uRLArray[i] = new URL(stringArray[i]);
            }
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return uRLArray;
    }

    public URLConfigurationSource(URL ... uRLArray) {
        this.configUrls = uRLArray;
    }

    public URLConfigurationSource() {
        String[] stringArray;
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = this.getConfigFileFromClasspath();
        if (uRL != null) {
            arrayList.add(uRL);
        }
        if ((stringArray = URLConfigurationSource.getDefaultFileSources()).length != 0) {
            arrayList.addAll(Arrays.asList(URLConfigurationSource.createUrls(stringArray)));
        }
        if (arrayList.size() == 0) {
            this.configUrls = new URL[0];
            logger.warn("No URLs will be polled as dynamic configuration sources.");
            logger.info("To enable URLs as dynamic configuration sources, define System property archaius.configurationSource.additionalUrls or make " + DEFAULT_CONFIG_FILE_FROM_CLASSPATH + " available on classpath.");
        } else {
            this.configUrls = arrayList.toArray(new URL[arrayList.size()]);
            logger.info("URLs to be used as dynamic configuration source: " + arrayList);
        }
    }

    private URL getConfigFileFromClasspath() {
        URL uRL = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            uRL = classLoader.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (uRL == null) {
            uRL = ClassLoader.getSystemResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        if (uRL == null) {
            uRL = URLConfigurationSource.class.getResource(DEFAULT_CONFIG_FILE_FROM_CLASSPATH);
        }
        return uRL;
    }

    public List<URL> getConfigUrls() {
        return Collections.unmodifiableList(Arrays.asList(this.configUrls));
    }

    private static final String[] getDefaultFileSources() {
        String string = System.getProperty(CONFIG_URL);
        String[] stringArray = string != null ? string.split(",") : new String[]{};
        return stringArray;
    }

    @Override
    public PollResult poll(boolean bl, Object object) throws IOException {
        if (this.configUrls == null || this.configUrls.length == 0) {
            return PollResult.createFull(null);
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (URL uRL : this.configUrls) {
            Properties properties = new Properties();
            InputStream inputStream2 = uRL.openStream();
            properties.load(inputStream2);
            inputStream2.close();
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                hashMap.put((String)entry.getKey(), entry.getValue());
            }
        }
        return PollResult.createFull(hashMap);
    }

    public String toString() {
        return "FileConfigurationSource [fileUrls=" + Arrays.toString(this.configUrls) + "]";
    }
}

