/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.AbstractCommand;
import com.netflix.hystrix.HystrixCommandResponseFromCache;
import rx.Observable;
import rx.Subscription;
import rx.functions.Action0;
import rx.subjects.ReplaySubject;

public class HystrixCachedObservable<R> {
    protected final Subscription originalSubscription;
    protected final Observable<R> cachedObservable;
    private volatile int outstandingSubscriptions = 0;

    protected HystrixCachedObservable(Observable<R> originalObservable) {
        ReplaySubject replaySubject = ReplaySubject.create();
        this.originalSubscription = originalObservable.subscribe(replaySubject);
        this.cachedObservable = replaySubject.doOnUnsubscribe(new Action0(){

            @Override
            public void call() {
                HystrixCachedObservable.this.outstandingSubscriptions--;
                if (HystrixCachedObservable.this.outstandingSubscriptions == 0) {
                    HystrixCachedObservable.this.originalSubscription.unsubscribe();
                }
            }
        }).doOnSubscribe(new Action0(){

            @Override
            public void call() {
                HystrixCachedObservable.this.outstandingSubscriptions++;
            }
        });
    }

    public static <R> HystrixCachedObservable<R> from(Observable<R> o, AbstractCommand<R> originalCommand) {
        return new HystrixCommandResponseFromCache<R>(o, originalCommand);
    }

    public static <R> HystrixCachedObservable<R> from(Observable<R> o) {
        return new HystrixCachedObservable<R>(o);
    }

    public Observable<R> toObservable() {
        return this.cachedObservable;
    }

    public void unsubscribe() {
        this.originalSubscription.unsubscribe();
    }
}

