/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix;

import com.netflix.hystrix.HystrixKey;
import com.netflix.hystrix.util.InternMap;

public interface HystrixThreadPoolKey
extends HystrixKey {

    public static class Factory {
        private static final InternMap<String, HystrixThreadPoolKey> intern = new InternMap<String, HystrixThreadPoolKey>(new InternMap.ValueConstructor<String, HystrixThreadPoolKey>(){

            @Override
            public HystrixThreadPoolKey create(String key) {
                return new HystrixThreadPoolKeyDefault(key);
            }
        });

        private Factory() {
        }

        public static HystrixThreadPoolKey asKey(String name) {
            return intern.interned(name);
        }

        static int getThreadPoolCount() {
            return intern.size();
        }

        private static class HystrixThreadPoolKeyDefault
        extends HystrixKey.HystrixKeyDefault
        implements HystrixThreadPoolKey {
            public HystrixThreadPoolKeyDefault(String name) {
                super(name);
            }
        }
    }
}

