/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class HystrixCommandCompletionStream
implements HystrixEventStream<HystrixCommandCompletion> {
    private final HystrixCommandKey commandKey;
    private final Subject<HystrixCommandCompletion, HystrixCommandCompletion> writeOnlySubject;
    private final Observable<HystrixCommandCompletion> readOnlyStream;
    private static final ConcurrentMap<String, HystrixCommandCompletionStream> streams = new ConcurrentHashMap<String, HystrixCommandCompletionStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixCommandCompletionStream getInstance(HystrixCommandKey commandKey) {
        HystrixCommandCompletionStream initialStream = (HystrixCommandCompletionStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<HystrixCommandCompletionStream> clazz = HystrixCommandCompletionStream.class;
        synchronized (HystrixCommandCompletionStream.class) {
            HystrixCommandCompletionStream existingStream = (HystrixCommandCompletionStream)streams.get(commandKey.name());
            if (existingStream == null) {
                HystrixCommandCompletionStream newStream = new HystrixCommandCompletionStream(commandKey);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return existingStream;
        }
    }

    HystrixCommandCompletionStream(HystrixCommandKey commandKey) {
        this.commandKey = commandKey;
        this.writeOnlySubject = new SerializedSubject<HystrixCommandCompletion, HystrixCommandCompletion>(PublishSubject.create());
        this.readOnlyStream = this.writeOnlySubject.share();
    }

    public static void reset() {
        streams.clear();
    }

    public void write(HystrixCommandCompletion event) {
        this.writeOnlySubject.onNext(event);
    }

    @Override
    public Observable<HystrixCommandCompletion> observe() {
        return this.readOnlyStream;
    }

    public String toString() {
        return "HystrixCommandCompletionStream(" + this.commandKey.name() + ")";
    }
}

