/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.metric.HystrixCommandExecutionStarted;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class HystrixCommandStartStream
implements HystrixEventStream<HystrixCommandExecutionStarted> {
    private final HystrixCommandKey commandKey;
    private final Subject<HystrixCommandExecutionStarted, HystrixCommandExecutionStarted> writeOnlySubject;
    private final Observable<HystrixCommandExecutionStarted> readOnlyStream;
    private static final ConcurrentMap<String, HystrixCommandStartStream> streams = new ConcurrentHashMap<String, HystrixCommandStartStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixCommandStartStream getInstance(HystrixCommandKey commandKey) {
        HystrixCommandStartStream initialStream = (HystrixCommandStartStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<HystrixCommandStartStream> clazz = HystrixCommandStartStream.class;
        synchronized (HystrixCommandStartStream.class) {
            HystrixCommandStartStream existingStream = (HystrixCommandStartStream)streams.get(commandKey.name());
            if (existingStream == null) {
                HystrixCommandStartStream newStream = new HystrixCommandStartStream(commandKey);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return existingStream;
        }
    }

    HystrixCommandStartStream(HystrixCommandKey commandKey) {
        this.commandKey = commandKey;
        this.writeOnlySubject = new SerializedSubject<HystrixCommandExecutionStarted, HystrixCommandExecutionStarted>(PublishSubject.create());
        this.readOnlyStream = this.writeOnlySubject.share();
    }

    public static void reset() {
        streams.clear();
    }

    public void write(HystrixCommandExecutionStarted event) {
        this.writeOnlySubject.onNext(event);
    }

    @Override
    public Observable<HystrixCommandExecutionStarted> observe() {
        return this.readOnlyStream;
    }

    public String toString() {
        return "HystrixCommandStartStream(" + this.commandKey.name() + ")";
    }
}

