/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixInvokableInfo;
import com.netflix.hystrix.metric.HystrixRequestEvents;
import java.util.Collection;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.Subject;

public class HystrixRequestEventsStream {
    private final Subject<HystrixRequestEvents, HystrixRequestEvents> writeOnlyRequestEventsSubject = PublishSubject.create();
    private final Observable<HystrixRequestEvents> readOnlyRequestEvents = this.writeOnlyRequestEventsSubject.onBackpressureBuffer(1024L);
    private static final HystrixRequestEventsStream INSTANCE = new HystrixRequestEventsStream();

    HystrixRequestEventsStream() {
    }

    public static HystrixRequestEventsStream getInstance() {
        return INSTANCE;
    }

    public void shutdown() {
        this.writeOnlyRequestEventsSubject.onCompleted();
    }

    public void write(Collection<HystrixInvokableInfo<?>> executions) {
        HystrixRequestEvents requestEvents = new HystrixRequestEvents(executions);
        this.writeOnlyRequestEventsSubject.onNext(requestEvents);
    }

    public Observable<HystrixRequestEvents> observe() {
        return this.readOnlyRequestEvents;
    }
}

