/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric;

import com.netflix.hystrix.HystrixThreadPoolKey;
import com.netflix.hystrix.metric.HystrixCommandExecutionStarted;
import com.netflix.hystrix.metric.HystrixEventStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import rx.Observable;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;
import rx.subjects.Subject;

public class HystrixThreadPoolStartStream
implements HystrixEventStream<HystrixCommandExecutionStarted> {
    private final HystrixThreadPoolKey threadPoolKey;
    private final Subject<HystrixCommandExecutionStarted, HystrixCommandExecutionStarted> writeOnlySubject;
    private final Observable<HystrixCommandExecutionStarted> readOnlyStream;
    private static final ConcurrentMap<String, HystrixThreadPoolStartStream> streams = new ConcurrentHashMap<String, HystrixThreadPoolStartStream>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HystrixThreadPoolStartStream getInstance(HystrixThreadPoolKey threadPoolKey) {
        HystrixThreadPoolStartStream initialStream = (HystrixThreadPoolStartStream)streams.get(threadPoolKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<HystrixThreadPoolStartStream> clazz = HystrixThreadPoolStartStream.class;
        synchronized (HystrixThreadPoolStartStream.class) {
            HystrixThreadPoolStartStream existingStream = (HystrixThreadPoolStartStream)streams.get(threadPoolKey.name());
            if (existingStream == null) {
                HystrixThreadPoolStartStream newStream = new HystrixThreadPoolStartStream(threadPoolKey);
                streams.putIfAbsent(threadPoolKey.name(), newStream);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return existingStream;
        }
    }

    HystrixThreadPoolStartStream(HystrixThreadPoolKey threadPoolKey) {
        this.threadPoolKey = threadPoolKey;
        this.writeOnlySubject = new SerializedSubject<HystrixCommandExecutionStarted, HystrixCommandExecutionStarted>(PublishSubject.create());
        this.readOnlyStream = this.writeOnlySubject.share();
    }

    public static void reset() {
        streams.clear();
    }

    public void write(HystrixCommandExecutionStarted event) {
        this.writeOnlySubject.onNext(event);
    }

    @Override
    public Observable<HystrixCommandExecutionStarted> observe() {
        return this.readOnlyStream;
    }

    public String toString() {
        return "HystrixThreadPoolStartStream(" + this.threadPoolKey.name() + ")";
    }
}

