/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.metric.consumer.RollingDistributionStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.HdrHistogram.Histogram;
import rx.functions.Func2;

public class RollingCommandLatencyDistributionStream
extends RollingDistributionStream<HystrixCommandCompletion> {
    private static final ConcurrentMap<String, RollingCommandLatencyDistributionStream> streams = new ConcurrentHashMap<String, RollingCommandLatencyDistributionStream>();
    private static final Func2<Histogram, HystrixCommandCompletion, Histogram> addValuesToBucket = new Func2<Histogram, HystrixCommandCompletion, Histogram>(){

        @Override
        public Histogram call(Histogram initialDistribution, HystrixCommandCompletion event) {
            if (event.didCommandExecute() && event.getExecutionLatency() > -1L) {
                initialDistribution.recordValue(event.getExecutionLatency());
            }
            return initialDistribution;
        }
    };

    public static RollingCommandLatencyDistributionStream getInstance(HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        int percentileMetricWindow = properties.metricsRollingPercentileWindowInMilliseconds().get();
        int numPercentileBuckets = properties.metricsRollingPercentileWindowBuckets().get();
        int percentileBucketSizeInMs = percentileMetricWindow / numPercentileBuckets;
        return RollingCommandLatencyDistributionStream.getInstance(commandKey, numPercentileBuckets, percentileBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingCommandLatencyDistributionStream getInstance(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        RollingCommandLatencyDistributionStream initialStream = (RollingCommandLatencyDistributionStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingCommandLatencyDistributionStream> clazz = RollingCommandLatencyDistributionStream.class;
        synchronized (RollingCommandLatencyDistributionStream.class) {
            RollingCommandLatencyDistributionStream existingStream = (RollingCommandLatencyDistributionStream)streams.get(commandKey.name());
            if (existingStream == null) {
                RollingCommandLatencyDistributionStream newStream = new RollingCommandLatencyDistributionStream(commandKey, numBuckets, bucketSizeInMs);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingCommandLatencyDistributionStream(HystrixCommandKey commandKey, int numPercentileBuckets, int percentileBucketSizeInMs) {
        super(HystrixCommandCompletionStream.getInstance(commandKey), numPercentileBuckets, percentileBucketSizeInMs, addValuesToBucket);
    }
}

