/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.metric.consumer;

import com.netflix.hystrix.HystrixCommandKey;
import com.netflix.hystrix.HystrixCommandProperties;
import com.netflix.hystrix.metric.HystrixCommandCompletion;
import com.netflix.hystrix.metric.HystrixCommandCompletionStream;
import com.netflix.hystrix.metric.consumer.RollingDistributionStream;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.HdrHistogram.Histogram;
import rx.functions.Func2;

public class RollingCommandUserLatencyDistributionStream
extends RollingDistributionStream<HystrixCommandCompletion> {
    private static final ConcurrentMap<String, RollingCommandUserLatencyDistributionStream> streams = new ConcurrentHashMap<String, RollingCommandUserLatencyDistributionStream>();
    private static final Func2<Histogram, HystrixCommandCompletion, Histogram> addValuesToBucket = new Func2<Histogram, HystrixCommandCompletion, Histogram>(){

        @Override
        public Histogram call(Histogram initialDistribution, HystrixCommandCompletion event) {
            if (event.didCommandExecute() && event.getTotalLatency() > -1L) {
                initialDistribution.recordValue(event.getTotalLatency());
            }
            return initialDistribution;
        }
    };

    public static RollingCommandUserLatencyDistributionStream getInstance(HystrixCommandKey commandKey, HystrixCommandProperties properties) {
        int percentileMetricWindow = properties.metricsRollingPercentileWindowInMilliseconds().get();
        int numPercentileBuckets = properties.metricsRollingPercentileWindowBuckets().get();
        int percentileBucketSizeInMs = percentileMetricWindow / numPercentileBuckets;
        return RollingCommandUserLatencyDistributionStream.getInstance(commandKey, numPercentileBuckets, percentileBucketSizeInMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RollingCommandUserLatencyDistributionStream getInstance(HystrixCommandKey commandKey, int numBuckets, int bucketSizeInMs) {
        RollingCommandUserLatencyDistributionStream initialStream = (RollingCommandUserLatencyDistributionStream)streams.get(commandKey.name());
        if (initialStream != null) {
            return initialStream;
        }
        Class<RollingCommandUserLatencyDistributionStream> clazz = RollingCommandUserLatencyDistributionStream.class;
        synchronized (RollingCommandUserLatencyDistributionStream.class) {
            RollingCommandUserLatencyDistributionStream existingStream = (RollingCommandUserLatencyDistributionStream)streams.get(commandKey.name());
            if (existingStream == null) {
                RollingCommandUserLatencyDistributionStream newStream = new RollingCommandUserLatencyDistributionStream(commandKey, numBuckets, bucketSizeInMs);
                streams.putIfAbsent(commandKey.name(), newStream);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return newStream;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return existingStream;
        }
    }

    public static void reset() {
        streams.clear();
    }

    private RollingCommandUserLatencyDistributionStream(HystrixCommandKey commandKey, int numPercentileBuckets, int percentileBucketSizeInMs) {
        super(HystrixCommandCompletionStream.getInstance(commandKey), numPercentileBuckets, percentileBucketSizeInMs, addValuesToBucket);
    }
}

