/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy;

import com.netflix.hystrix.strategy.HystrixArchaiusHelper;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategy;
import com.netflix.hystrix.strategy.concurrency.HystrixConcurrencyStrategyDefault;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifier;
import com.netflix.hystrix.strategy.eventnotifier.HystrixEventNotifierDefault;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHook;
import com.netflix.hystrix.strategy.executionhook.HystrixCommandExecutionHookDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisher;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherDefault;
import com.netflix.hystrix.strategy.metrics.HystrixMetricsPublisherFactory;
import com.netflix.hystrix.strategy.properties.HystrixDynamicProperties;
import com.netflix.hystrix.strategy.properties.HystrixDynamicPropertiesSystemProperties;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategyDefault;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixPlugins {
    private final ClassLoader classLoader;
    final AtomicReference<HystrixEventNotifier> notifier = new AtomicReference();
    final AtomicReference<HystrixConcurrencyStrategy> concurrencyStrategy = new AtomicReference();
    final AtomicReference<HystrixMetricsPublisher> metricsPublisher = new AtomicReference();
    final AtomicReference<HystrixPropertiesStrategy> propertiesFactory = new AtomicReference();
    final AtomicReference<HystrixCommandExecutionHook> commandExecutionHook = new AtomicReference();
    private final HystrixDynamicProperties dynamicProperties;

    private HystrixPlugins(ClassLoader classLoader, LoggerSupplier logSupplier) {
        this.classLoader = classLoader;
        this.dynamicProperties = HystrixPlugins.resolveDynamicProperties(classLoader, logSupplier);
    }

    static HystrixPlugins create(ClassLoader classLoader, LoggerSupplier logSupplier) {
        return new HystrixPlugins(classLoader, logSupplier);
    }

    static HystrixPlugins create(ClassLoader classLoader) {
        return new HystrixPlugins(classLoader, new LoggerSupplier(){

            @Override
            public Logger getLogger() {
                return LoggerFactory.getLogger(HystrixPlugins.class);
            }
        });
    }

    static HystrixPlugins create() {
        return HystrixPlugins.create(HystrixPlugins.class.getClassLoader());
    }

    public static HystrixPlugins getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void reset() {
        HystrixPlugins.getInstance().notifier.set(null);
        HystrixPlugins.getInstance().concurrencyStrategy.set(null);
        HystrixPlugins.getInstance().metricsPublisher.set(null);
        HystrixPlugins.getInstance().propertiesFactory.set(null);
        HystrixPlugins.getInstance().commandExecutionHook.set(null);
        HystrixMetricsPublisherFactory.reset();
    }

    public HystrixEventNotifier getEventNotifier() {
        if (this.notifier.get() == null) {
            HystrixEventNotifier impl = this.getPluginImplementation(HystrixEventNotifier.class);
            if (impl == null) {
                this.notifier.compareAndSet(null, HystrixEventNotifierDefault.getInstance());
            } else {
                this.notifier.compareAndSet(null, impl);
            }
        }
        return this.notifier.get();
    }

    public void registerEventNotifier(HystrixEventNotifier impl) {
        if (!this.notifier.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixConcurrencyStrategy getConcurrencyStrategy() {
        if (this.concurrencyStrategy.get() == null) {
            HystrixConcurrencyStrategy impl = this.getPluginImplementation(HystrixConcurrencyStrategy.class);
            if (impl == null) {
                this.concurrencyStrategy.compareAndSet(null, HystrixConcurrencyStrategyDefault.getInstance());
            } else {
                this.concurrencyStrategy.compareAndSet(null, impl);
            }
        }
        return this.concurrencyStrategy.get();
    }

    public void registerConcurrencyStrategy(HystrixConcurrencyStrategy impl) {
        if (!this.concurrencyStrategy.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixMetricsPublisher getMetricsPublisher() {
        if (this.metricsPublisher.get() == null) {
            HystrixMetricsPublisher impl = this.getPluginImplementation(HystrixMetricsPublisher.class);
            if (impl == null) {
                this.metricsPublisher.compareAndSet(null, HystrixMetricsPublisherDefault.getInstance());
            } else {
                this.metricsPublisher.compareAndSet(null, impl);
            }
        }
        return this.metricsPublisher.get();
    }

    public void registerMetricsPublisher(HystrixMetricsPublisher impl) {
        if (!this.metricsPublisher.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixPropertiesStrategy getPropertiesStrategy() {
        if (this.propertiesFactory.get() == null) {
            HystrixPropertiesStrategy impl = this.getPluginImplementation(HystrixPropertiesStrategy.class);
            if (impl == null) {
                this.propertiesFactory.compareAndSet(null, HystrixPropertiesStrategyDefault.getInstance());
            } else {
                this.propertiesFactory.compareAndSet(null, impl);
            }
        }
        return this.propertiesFactory.get();
    }

    public HystrixDynamicProperties getDynamicProperties() {
        return this.dynamicProperties;
    }

    public void registerPropertiesStrategy(HystrixPropertiesStrategy impl) {
        if (!this.propertiesFactory.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    public HystrixCommandExecutionHook getCommandExecutionHook() {
        if (this.commandExecutionHook.get() == null) {
            HystrixCommandExecutionHook impl = this.getPluginImplementation(HystrixCommandExecutionHook.class);
            if (impl == null) {
                this.commandExecutionHook.compareAndSet(null, HystrixCommandExecutionHookDefault.getInstance());
            } else {
                this.commandExecutionHook.compareAndSet(null, impl);
            }
        }
        return this.commandExecutionHook.get();
    }

    public void registerCommandExecutionHook(HystrixCommandExecutionHook impl) {
        if (!this.commandExecutionHook.compareAndSet(null, impl)) {
            throw new IllegalStateException("Another strategy was already registered.");
        }
    }

    private <T> T getPluginImplementation(Class<T> pluginClass) {
        T p = HystrixPlugins.getPluginImplementationViaProperties(pluginClass, this.dynamicProperties);
        if (p != null) {
            return p;
        }
        return HystrixPlugins.findService(pluginClass, this.classLoader);
    }

    private static <T> T getPluginImplementationViaProperties(Class<T> pluginClass, HystrixDynamicProperties dynamicProperties) {
        String classSimpleName = pluginClass.getSimpleName();
        String propertyName = "hystrix.plugin." + classSimpleName + ".implementation";
        String implementingClass = (String)dynamicProperties.getString(propertyName, null).get();
        if (implementingClass != null) {
            try {
                Class<Object> cls = Class.forName(implementingClass);
                cls = cls.asSubclass(pluginClass);
                return (T)cls.newInstance();
            }
            catch (ClassCastException e) {
                throw new RuntimeException(classSimpleName + " implementation is not an instance of " + classSimpleName + ": " + implementingClass);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(classSimpleName + " implementation class not found: " + implementingClass, e);
            }
            catch (InstantiationException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be instantiated: " + implementingClass, e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(classSimpleName + " implementation not able to be accessed: " + implementingClass, e);
            }
        }
        return null;
    }

    private static HystrixDynamicProperties resolveDynamicProperties(ClassLoader classLoader, LoggerSupplier logSupplier) {
        HystrixDynamicProperties hp = HystrixPlugins.getPluginImplementationViaProperties(HystrixDynamicProperties.class, HystrixDynamicPropertiesSystemProperties.getInstance());
        if (hp != null) {
            logSupplier.getLogger().debug("Created HystrixDynamicProperties instance from System property named \"hystrix.plugin.HystrixDynamicProperties.implementation\". Using class: {}", (Object)hp.getClass().getCanonicalName());
            return hp;
        }
        hp = HystrixPlugins.findService(HystrixDynamicProperties.class, classLoader);
        if (hp != null) {
            logSupplier.getLogger().debug("Created HystrixDynamicProperties instance by loading from ServiceLoader. Using class: {}", (Object)hp.getClass().getCanonicalName());
            return hp;
        }
        hp = HystrixArchaiusHelper.createArchaiusDynamicProperties();
        if (hp != null) {
            logSupplier.getLogger().debug("Created HystrixDynamicProperties. Using class : {}", (Object)hp.getClass().getCanonicalName());
            return hp;
        }
        hp = HystrixDynamicPropertiesSystemProperties.getInstance();
        logSupplier.getLogger().info("Using System Properties for HystrixDynamicProperties! Using class: {}", (Object)hp.getClass().getCanonicalName());
        return hp;
    }

    private static <T> T findService(Class<T> spi, ClassLoader classLoader) throws ServiceConfigurationError {
        ServiceLoader<T> sl = ServiceLoader.load(spi, classLoader);
        for (T s2 : sl) {
            if (s2 == null) continue;
            return s2;
        }
        return null;
    }

    static interface LoggerSupplier {
        public Logger getLogger();
    }

    private static class LazyHolder {
        private static final HystrixPlugins INSTANCE = HystrixPlugins.create();

        private LazyHolder() {
        }
    }
}

