/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.strategy.properties;

import com.netflix.hystrix.strategy.properties.HystrixDynamicProperty;

public interface HystrixDynamicProperties {
    public HystrixDynamicProperty<String> getString(String var1, String var2);

    public HystrixDynamicProperty<Integer> getInteger(String var1, Integer var2);

    public HystrixDynamicProperty<Long> getLong(String var1, Long var2);

    public HystrixDynamicProperty<Boolean> getBoolean(String var1, Boolean var2);

    public static class Util {
        public static <T> HystrixDynamicProperty<T> getProperty(HystrixDynamicProperties properties, String name, T fallback, Class<T> type) {
            return Util.doProperty(properties, name, fallback, type);
        }

        private static HystrixDynamicProperty<?> doProperty(HystrixDynamicProperties delegate, String name, Object fallback, Class<?> type) {
            if (type == String.class) {
                return delegate.getString(name, (String)fallback);
            }
            if (type == Integer.class) {
                return delegate.getInteger(name, (Integer)fallback);
            }
            if (type == Long.class) {
                return delegate.getLong(name, (Long)fallback);
            }
            if (type == Boolean.class) {
                return delegate.getBoolean(name, (Boolean)fallback);
            }
            throw new IllegalStateException();
        }
    }
}

