/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.hystrix.util;

import com.netflix.hystrix.strategy.HystrixPlugins;
import com.netflix.hystrix.strategy.properties.HystrixPropertiesStrategy;
import com.netflix.hystrix.util.PlatformSpecific;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HystrixTimer {
    private static final Logger logger = LoggerFactory.getLogger(HystrixTimer.class);
    private static HystrixTimer INSTANCE = new HystrixTimer();
    AtomicReference<ScheduledExecutor> executor = new AtomicReference();

    private HystrixTimer() {
    }

    public static HystrixTimer getInstance() {
        return INSTANCE;
    }

    public static void reset() {
        ScheduledExecutor ex = HystrixTimer.INSTANCE.executor.getAndSet(null);
        if (ex != null && ex.getThreadPool() != null) {
            ex.getThreadPool().shutdownNow();
        }
    }

    public Reference<TimerListener> addTimerListener(final TimerListener listener) {
        this.startThreadIfNeeded();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    listener.tick();
                }
                catch (Exception e) {
                    logger.error("Failed while ticking TimerListener", e);
                }
            }
        };
        ScheduledFuture<?> f = this.executor.get().getThreadPool().scheduleAtFixedRate(r, listener.getIntervalTimeInMilliseconds(), listener.getIntervalTimeInMilliseconds(), TimeUnit.MILLISECONDS);
        return new TimerReference(listener, f);
    }

    protected void startThreadIfNeeded() {
        while (this.executor.get() == null || !this.executor.get().isInitialized()) {
            if (!this.executor.compareAndSet(null, new ScheduledExecutor())) continue;
            this.executor.get().initialize();
        }
    }

    public static interface TimerListener {
        public void tick();

        public int getIntervalTimeInMilliseconds();
    }

    static class ScheduledExecutor {
        volatile ScheduledThreadPoolExecutor executor;
        private volatile boolean initialized;

        ScheduledExecutor() {
        }

        public void initialize() {
            HystrixPropertiesStrategy propertiesStrategy = HystrixPlugins.getInstance().getPropertiesStrategy();
            int coreSize = propertiesStrategy.getTimerThreadPoolProperties().getCorePoolSize().get();
            ThreadFactory threadFactory = null;
            threadFactory = !PlatformSpecific.isAppEngineStandardEnvironment() ? new ThreadFactory(){
                final AtomicInteger counter = new AtomicInteger();

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread2 = new Thread(r, "HystrixTimer-" + this.counter.incrementAndGet());
                    thread2.setDaemon(true);
                    return thread2;
                }
            } : PlatformSpecific.getAppEngineThreadFactory();
            this.executor = new ScheduledThreadPoolExecutor(coreSize, threadFactory);
            this.initialized = true;
        }

        public ScheduledThreadPoolExecutor getThreadPool() {
            return this.executor;
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    private static class TimerReference
    extends SoftReference<TimerListener> {
        private final ScheduledFuture<?> f;

        TimerReference(TimerListener referent, ScheduledFuture<?> f) {
            super(referent);
            this.f = f;
        }

        @Override
        public void clear() {
            super.clear();
            this.f.cancel(false);
        }
    }
}

