/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import feign.Capability;
import feign.Contract;
import feign.InvocationHandlerFactory;
import feign.hystrix.FallbackFactory;
import feign.hystrix.HystrixDelegatingContract;
import feign.hystrix.HystrixInvocationHandler;
import feign.hystrix.SetterFactory;
import java.util.HashMap;
import java.util.Map;

public final class HystrixCapability
implements Capability {
    private SetterFactory setterFactory = new SetterFactory.Default();
    private final Map<Class, Object> fallbacks = new HashMap<Class, Object>();

    public HystrixCapability setterFactory(SetterFactory setterFactory) {
        this.setterFactory = setterFactory;
        return this;
    }

    @Override
    public Contract enrich(Contract contract) {
        return new HystrixDelegatingContract(contract);
    }

    @Override
    public InvocationHandlerFactory enrich(InvocationHandlerFactory invocationHandlerFactory) {
        return (target, dispatch) -> new HystrixInvocationHandler(target, dispatch, this.setterFactory, this.fallbacks.containsKey(target.type()) ? new FallbackFactory.Default<Object>(this.fallbacks.get(target.type())) : null);
    }

    public <E> Capability fallback(Class<E> api, E fallback) {
        this.fallbacks.put(api, fallback);
        return this;
    }
}

