/*
 * Decompiled with CFR 0.152.
 */
package feign.hystrix;

import com.netflix.hystrix.HystrixCommand;
import feign.Contract;
import feign.MethodMetadata;
import feign.Util;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import rx.Completable;
import rx.Observable;
import rx.Single;

public final class HystrixDelegatingContract
implements Contract {
    private final Contract delegate;

    public HystrixDelegatingContract(Contract delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<MethodMetadata> parseAndValidateMetadata(Class<?> targetType) {
        List<MethodMetadata> metadatas = this.delegate.parseAndValidateMetadata(targetType);
        for (MethodMetadata metadata : metadatas) {
            Type actualType;
            Type type = metadata.returnType();
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(HystrixCommand.class)) {
                actualType = Util.resolveLastTypeParameter(type, HystrixCommand.class);
                metadata.returnType(actualType);
                continue;
            }
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Observable.class)) {
                actualType = Util.resolveLastTypeParameter(type, Observable.class);
                metadata.returnType(actualType);
                continue;
            }
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Single.class)) {
                actualType = Util.resolveLastTypeParameter(type, Single.class);
                metadata.returnType(actualType);
                continue;
            }
            if (type instanceof ParameterizedType && ((ParameterizedType)type).getRawType().equals(Completable.class)) {
                metadata.returnType(Void.TYPE);
                continue;
            }
            if (!(type instanceof ParameterizedType) || !((ParameterizedType)type).getRawType().equals(CompletableFuture.class)) continue;
            metadata.returnType(Util.resolveLastTypeParameter(type, CompletableFuture.class));
        }
        return metadatas;
    }
}

