/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.commands.VerboseCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.serialization.SerializationHandles;
import io.github.bucket4j.distributed.versioning.Version;
import java.io.IOException;
import java.util.Map;

public interface RemoteCommand<T> {
    public CommandResult<T> execute(MutableBucketEntry var1, long var2);

    default public VerboseCommand<T> asVerbose() {
        return VerboseCommand.from(this);
    }

    default public boolean isInitializationCommand() {
        return false;
    }

    default public boolean canBeMerged(RemoteCommand<?> another) {
        return false;
    }

    default public void mergeInto(RemoteCommand<?> mergedCommand) {
        throw new UnsupportedOperationException();
    }

    default public RemoteCommand<?> toMergedCommand() {
        throw new UnsupportedOperationException();
    }

    default public boolean isMerged() {
        return false;
    }

    default public CommandResult<?> unwrapOneResult(T result, int indice) {
        throw new UnsupportedOperationException();
    }

    default public int getMergedCommandsCount() {
        throw new UnsupportedOperationException();
    }

    public SerializationHandle<RemoteCommand<?>> getSerializationHandle();

    public boolean isImmediateSyncRequired(long var1, long var3);

    public long estimateTokensToConsume();

    public long getConsumedTokens(T var1);

    public Version getRequiredVersion();

    public static <O> void serialize(SerializationAdapter<O> adapter2, O output, RemoteCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
        SerializationHandle<RemoteCommand<?>> serializer = command.getSerializationHandle();
        adapter2.writeInt(output, serializer.getTypeId());
        serializer.serialize(adapter2, output, command, backwardCompatibilityVersion, scope);
    }

    public static <I> RemoteCommand<?> deserialize(DeserializationAdapter<I> adapter2, I input) throws IOException {
        int typeId = adapter2.readInt(input);
        SerializationHandle serializer = SerializationHandles.CORE_HANDLES.getHandleByTypeId(typeId);
        return (RemoteCommand)serializer.deserialize(adapter2, input);
    }

    public static RemoteCommand<?> fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
        String typeName = (String)snapshot.get("type");
        SerializationHandle<?> serializer = SerializationHandles.CORE_HANDLES.getHandleByTypeName(typeName);
        return (RemoteCommand)serializer.fromJsonCompatibleSnapshot(snapshot);
    }

    public static Map<String, Object> toJsonCompatibleSnapshot(RemoteCommand<?> command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
        SerializationHandle<RemoteCommand<?>> serializer = command.getSerializationHandle();
        Map<String, Object> result = command.getSerializationHandle().toJsonCompatibleSnapshot(command, backwardCompatibilityVersion, scope);
        result.put("type", serializer.getTypeName());
        return result;
    }
}

