/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.remote.commands;

import io.github.bucket4j.distributed.remote.CommandResult;
import io.github.bucket4j.distributed.remote.MutableBucketEntry;
import io.github.bucket4j.distributed.remote.RemoteBucketState;
import io.github.bucket4j.distributed.remote.RemoteCommand;
import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.PrimitiveSerializationHandles;
import io.github.bucket4j.distributed.serialization.Scope;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationHandle;
import io.github.bucket4j.distributed.versioning.Version;
import io.github.bucket4j.distributed.versioning.Versions;
import io.github.bucket4j.util.ComparableByContent;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ConsumeIgnoringRateLimitsCommand
implements RemoteCommand<Long>,
ComparableByContent<ConsumeIgnoringRateLimitsCommand> {
    private long tokensToConsume;
    public static final SerializationHandle<ConsumeIgnoringRateLimitsCommand> SERIALIZATION_HANDLE = new SerializationHandle<ConsumeIgnoringRateLimitsCommand>(){

        @Override
        public <S> ConsumeIgnoringRateLimitsCommand deserialize(DeserializationAdapter<S> adapter2, S input) throws IOException {
            int formatNumber = adapter2.readInt(input);
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToConsume = adapter2.readLong(input);
            return new ConsumeIgnoringRateLimitsCommand(tokensToConsume);
        }

        @Override
        public <O> void serialize(SerializationAdapter<O> adapter2, O output, ConsumeIgnoringRateLimitsCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            adapter2.writeInt(output, Versions.v_7_0_0.getNumber());
            adapter2.writeLong(output, command.tokensToConsume);
        }

        @Override
        public int getTypeId() {
            return 34;
        }

        @Override
        public Class<ConsumeIgnoringRateLimitsCommand> getSerializedType() {
            return ConsumeIgnoringRateLimitsCommand.class;
        }

        @Override
        public ConsumeIgnoringRateLimitsCommand fromJsonCompatibleSnapshot(Map<String, Object> snapshot) throws IOException {
            int formatNumber = this.readIntValue(snapshot, "version");
            Versions.check(formatNumber, Versions.v_7_0_0, Versions.v_7_0_0);
            long tokensToConsume = this.readLongValue(snapshot, "tokensToConsume");
            return new ConsumeIgnoringRateLimitsCommand(tokensToConsume);
        }

        @Override
        public Map<String, Object> toJsonCompatibleSnapshot(ConsumeIgnoringRateLimitsCommand command, Version backwardCompatibilityVersion, Scope scope) throws IOException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("version", Versions.v_7_0_0.getNumber());
            result.put("tokensToConsume", command.tokensToConsume);
            return result;
        }

        @Override
        public String getTypeName() {
            return "ConsumeIgnoringRateLimitsCommand";
        }
    };

    public ConsumeIgnoringRateLimitsCommand(long limit) {
        this.tokensToConsume = limit;
    }

    public long getTokensToConsume() {
        return this.tokensToConsume;
    }

    @Override
    public CommandResult<Long> execute(MutableBucketEntry mutableEntry, long currentTimeNanos) {
        if (!mutableEntry.exists()) {
            return CommandResult.bucketNotFound();
        }
        RemoteBucketState state = mutableEntry.get();
        state.refillAllBandwidth(currentTimeNanos);
        long nanosToCloseDeficit = state.calculateDelayNanosAfterWillBePossibleToConsume(this.tokensToConsume, currentTimeNanos, false);
        if (nanosToCloseDeficit == Long.MAX_VALUE) {
            return CommandResult.success(Long.valueOf(Long.MAX_VALUE), PrimitiveSerializationHandles.LONG_HANDLE);
        }
        state.consume(this.tokensToConsume);
        mutableEntry.set(state);
        return CommandResult.success(Long.valueOf(nanosToCloseDeficit), PrimitiveSerializationHandles.LONG_HANDLE);
    }

    @Override
    public SerializationHandle<RemoteCommand<?>> getSerializationHandle() {
        return SERIALIZATION_HANDLE;
    }

    @Override
    public boolean equalsByContent(ConsumeIgnoringRateLimitsCommand other) {
        return this.tokensToConsume == other.tokensToConsume;
    }

    @Override
    public boolean isImmediateSyncRequired(long unsynchronizedTokens, long nanosSinceLastSync) {
        return false;
    }

    @Override
    public long estimateTokensToConsume() {
        return this.tokensToConsume;
    }

    @Override
    public long getConsumedTokens(Long result) {
        return result == Long.MAX_VALUE ? 0L : this.tokensToConsume;
    }

    @Override
    public Version getRequiredVersion() {
        return Versions.v_7_0_0;
    }
}

