/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j.distributed.serialization;

import io.github.bucket4j.distributed.serialization.DeserializationAdapter;
import io.github.bucket4j.distributed.serialization.SerializationAdapter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class DataOutputSerializationAdapter
implements SerializationAdapter<DataOutput>,
DeserializationAdapter<DataInput> {
    public static DataOutputSerializationAdapter INSTANCE = new DataOutputSerializationAdapter();

    private DataOutputSerializationAdapter() {
    }

    @Override
    public boolean readBoolean(DataInput source2) throws IOException {
        return source2.readBoolean();
    }

    @Override
    public byte readByte(DataInput source2) throws IOException {
        return source2.readByte();
    }

    @Override
    public int readInt(DataInput source2) throws IOException {
        return source2.readInt();
    }

    @Override
    public long readLong(DataInput source2) throws IOException {
        return source2.readLong();
    }

    @Override
    public long[] readLongArray(DataInput source2) throws IOException {
        int size = source2.readInt();
        long[] array = new long[size];
        for (int i = 0; i < size; ++i) {
            array[i] = source2.readLong();
        }
        return array;
    }

    @Override
    public double[] readDoubleArray(DataInput source2) throws IOException {
        int size = source2.readInt();
        double[] array = new double[size];
        for (int i = 0; i < size; ++i) {
            array[i] = source2.readDouble();
        }
        return array;
    }

    @Override
    public String readString(DataInput source2) throws IOException {
        return source2.readUTF();
    }

    @Override
    public void writeBoolean(DataOutput target, boolean value) throws IOException {
        target.writeBoolean(value);
    }

    @Override
    public void writeByte(DataOutput target, byte value) throws IOException {
        target.writeByte(value);
    }

    @Override
    public void writeInt(DataOutput target, int value) throws IOException {
        target.writeInt(value);
    }

    @Override
    public void writeLong(DataOutput target, long value) throws IOException {
        target.writeLong(value);
    }

    @Override
    public void writeLongArray(DataOutput target, long[] value) throws IOException {
        target.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            target.writeLong(value[i]);
        }
    }

    @Override
    public void writeDoubleArray(DataOutput target, double[] value) throws IOException {
        target.writeInt(value.length);
        for (int i = 0; i < value.length; ++i) {
            target.writeDouble(value[i]);
        }
    }

    @Override
    public void writeString(DataOutput target, String value) throws IOException {
        target.writeUTF(value);
    }
}

